/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueListRecordCursor;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestByDeferredListValuesFilteredRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    private final ObjList<Function> symbolFunctions;
    private final Function filter;
    private final LatestByValueListRecordCursor cursor;
    private final int frameSymbolIndex;

    public LatestByDeferredListValuesFilteredRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, int columnIndex, @Nullable ObjList<Function> symbolFunctions, @Nullable Function filter, @NotNull IntList columnIndexes) {
        super(metadata, dataFrameCursorFactory);
        this.symbolFunctions = symbolFunctions;
        this.filter = filter;
        this.frameSymbolIndex = columnIndexes.getQuick(columnIndex);
        this.cursor = new LatestByValueListRecordCursor(columnIndex, filter, columnIndexes, configuration.getDefaultSymbolCapacity(), symbolFunctions != null);
    }

    public LatestByDeferredListValuesFilteredRecordCursorFactory(@NotNull CairoConfiguration configuration, RecordMetadata metadata, DataFrameCursorFactory dataFrameCursorFactory, int latestByIndex, Function filter, IntList columnIndexes) {
        this(configuration, metadata, dataFrameCursorFactory, latestByIndex, null, filter, columnIndexes);
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.filter);
        this.cursor.destroy();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.lookupDeferredSymbol(dataFrameCursor, executionContext);
        this.cursor.of(dataFrameCursor, executionContext);
        return this.cursor;
    }

    private void lookupDeferredSymbol(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        IntHashSet symbolKeys;
        if (this.symbolFunctions != null && (symbolKeys = this.cursor.getSymbolKeys()).size() < this.symbolFunctions.size()) {
            symbolKeys.clear();
            StaticSymbolTable symbolMapReader = dataFrameCursor.getSymbolTable(this.frameSymbolIndex);
            int n = this.symbolFunctions.size();
            for (int i = 0; i < n; ++i) {
                Function symbolFunc = this.symbolFunctions.getQuick(i);
                symbolFunc.init(dataFrameCursor, executionContext);
                int key = symbolMapReader.keyOf(symbolFunc.getStr(null));
                if (key == -2) continue;
                symbolKeys.add(key);
            }
        }
    }
}

