/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.std.Unsafe;

public final class LatestByArguments {
    public static final long MEMORY_SIZE = 56L;
    private static final long KEY_LO_OFFSET = 0L;
    private static final long KEY_HI_OFFSET = 8L;
    private static final long ROWS_ADDRESS_OFFSET = 16L;
    private static final long ROWS_CAPACITY_OFFSET = 24L;
    private static final long ROWS_SIZE_OFFSET = 32L;
    private static final long HASHES_ADDRESS_OFFSET = 40L;
    private static final long FILTERED_SIZE_OFFSET = 48L;

    public static long allocateMemory() {
        return Unsafe.calloc(56L, 1);
    }

    public static long allocateMemoryArray(int elements) {
        return Unsafe.calloc(56L * (long)elements, 1);
    }

    public static long getFilteredSize(long address) {
        return Unsafe.getUnsafe().getLong(address + 48L);
    }

    public static void setFilteredSize(long address, long size) {
        Unsafe.getUnsafe().putLong(address + 48L, size);
    }

    public static long getHashesAddress(long address) {
        return Unsafe.getUnsafe().getLong(address + 40L);
    }

    public static long getKeyHi(long address) {
        return Unsafe.getUnsafe().getLong(address + 8L);
    }

    public static long getKeyLo(long address) {
        return Unsafe.getUnsafe().getLong(address + 0L);
    }

    public static long getRowsAddress(long address) {
        return Unsafe.getUnsafe().getLong(address + 16L);
    }

    public static long getRowsCapacity(long address) {
        return Unsafe.getUnsafe().getLong(address + 24L);
    }

    public static long getRowsSize(long address) {
        return Unsafe.getUnsafe().getLong(address + 32L);
    }

    public static void releaseMemory(long address) {
        Unsafe.free(address, 56L, 1);
    }

    public static void releaseMemoryArray(long address, int elements) {
        Unsafe.free(address, 56L * (long)elements, 1);
    }

    public static void setHashesAddress(long address, long addr) {
        Unsafe.getUnsafe().putLong(address + 40L, addr);
    }

    public static void setKeyHi(long address, long up) {
        Unsafe.getUnsafe().putLong(address + 8L, up);
    }

    public static void setKeyLo(long address, long lo) {
        Unsafe.getUnsafe().putLong(address + 0L, lo);
    }

    public static void setRowsAddress(long address, long addr) {
        Unsafe.getUnsafe().putLong(address + 16L, addr);
    }

    public static void setRowsCapacity(long address, long cap) {
        Unsafe.getUnsafe().putLong(address + 24L, cap);
    }

    public static void setRowsSize(long address, long size) {
        Unsafe.getUnsafe().putLong(address + 32L, size);
    }
}

