/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.HeapRowCursor;
import io.questdb.std.ObjList;

public class HeapRowCursorFactory
implements RowCursorFactory {
    private final ObjList<? extends RowCursorFactory> cursorFactories;
    private final ObjList<RowCursor> cursors;
    private final HeapRowCursor cursor;

    public HeapRowCursorFactory(ObjList<? extends RowCursorFactory> cursorFactories) {
        this.cursorFactories = cursorFactories;
        this.cursors = new ObjList();
        this.cursor = new HeapRowCursor();
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public RowCursor getCursor(DataFrame dataFrame) {
        int n = this.cursorFactories.size();
        for (int i = 0; i < n; ++i) {
            this.cursors.extendAndSet(i, this.cursorFactories.getQuick(i).getCursor(dataFrame));
        }
        this.cursor.of(this.cursors);
        return this.cursor;
    }

    @Override
    public void prepareCursor(TableReader tableReader, SqlExecutionContext sqlExecutionContext) throws SqlException {
        RowCursorFactory.prepareCursor(this.cursorFactories, tableReader, sqlExecutionContext);
    }
}

