/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.ReaderOutOfDateException;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRecordCursor;
import io.questdb.griffin.engine.table.HeapRowCursorFactory;
import io.questdb.griffin.engine.table.SequentialRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolFunctionRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexRowCursorFactory;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterOnExcludedValuesRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    private final DataFrameRecordCursor cursor;
    private final int columnIndex;
    private final Function filter;
    private final ObjList<SymbolFunctionRowCursorFactory> cursorFactories;
    private int cursorFactoriesIdx;
    private final ObjList<Function> keyExcludedValueFunctions = new ObjList();
    private final IntHashSet includedKeys = new IntHashSet();
    private final IntHashSet excludedKeys = new IntHashSet();
    private final boolean dynamicExcludedKeys;
    private final boolean followedOrderByAdvice;
    private final int indexDirection;
    private final int maxSymbolNotEqualsCount;
    private final IntList columnIndexes;

    public FilterOnExcludedValuesRecordCursorFactory(@NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, @NotNull ObjList<Function> keyValues, int columnIndex, @Nullable Function filter, int orderByMnemonic, boolean followedOrderByAdvice, int indexDirection, @NotNull IntList columnIndexes, int maxSymbolNotEqualsCount) {
        super(metadata, dataFrameCursorFactory);
        this.indexDirection = indexDirection;
        this.maxSymbolNotEqualsCount = maxSymbolNotEqualsCount;
        int nKeyValues = keyValues.size();
        boolean dynamicValues = false;
        for (int i = 0; i < nKeyValues; ++i) {
            if (keyValues.getQuick(i).isConstant()) continue;
            dynamicValues = true;
            break;
        }
        this.dynamicExcludedKeys = dynamicValues;
        this.keyExcludedValueFunctions.addAll(keyValues);
        this.columnIndex = columnIndex;
        this.filter = filter;
        this.cursorFactories = new ObjList(nKeyValues);
        this.cursor = orderByMnemonic == 2 ? new DataFrameRecordCursor(new SequentialRowCursorFactory(this.cursorFactories), false, filter, columnIndexes) : new DataFrameRecordCursor(new HeapRowCursorFactory(this.cursorFactories), false, filter, columnIndexes);
        this.followedOrderByAdvice = followedOrderByAdvice;
        this.columnIndexes = columnIndexes;
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.filter);
        Misc.free(this.keyExcludedValueFunctions);
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.followedOrderByAdvice;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    public void recalculateIncludedValues(TableReader tableReader) {
        this.cursorFactoriesIdx = 0;
        this.excludedKeys.clear();
        if (this.dynamicExcludedKeys) {
            this.includedKeys.clear();
        }
        SymbolMapReaderImpl symbolMapReader = (SymbolMapReaderImpl)tableReader.getSymbolMapReader(this.columnIndex);
        int n = this.keyExcludedValueFunctions.size();
        for (int i = 0; i < n; ++i) {
            CharSequence value = this.keyExcludedValueFunctions.getQuick(i).getStr(null);
            this.excludedKeys.add(symbolMapReader.keyOf(value));
        }
        n = symbolMapReader.getSymbolCount();
        for (int k = 0; k < n; ++k) {
            if (this.excludedKeys.contains(k) || !this.includedKeys.add(k)) continue;
            this.upsertRowCursorFactory(k);
        }
        if (symbolMapReader.containsNullValue() && !this.excludedKeys.contains(Integer.MIN_VALUE) && this.includedKeys.add(Integer.MIN_VALUE)) {
            this.upsertRowCursorFactory(Integer.MIN_VALUE);
        }
    }

    private void upsertRowCursorFactory(int symbolKey) {
        if (this.cursorFactoriesIdx < this.cursorFactories.size()) {
            this.cursorFactories.get(this.cursorFactoriesIdx).of(symbolKey);
            ++this.cursorFactoriesIdx;
            return;
        }
        SymbolFunctionRowCursorFactory rowCursorFactory = this.filter == null ? new SymbolIndexRowCursorFactory(this.columnIndex, symbolKey, false, this.indexDirection, null) : new SymbolIndexFilteredRowCursorFactory(this.columnIndex, symbolKey, this.filter, false, this.indexDirection, this.columnIndexes, null);
        this.cursorFactories.add(rowCursorFactory);
        ++this.cursorFactoriesIdx;
    }

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        TableReader reader = dataFrameCursor.getTableReader();
        if (reader.getSymbolMapReader(this.columnIndex).getSymbolCount() > this.maxSymbolNotEqualsCount) {
            throw ReaderOutOfDateException.of(reader.getTableName());
        }
        Function.init(this.keyExcludedValueFunctions, reader, executionContext);
        this.recalculateIncludedValues(reader);
        this.cursor.of(dataFrameCursor, executionContext);
        if (this.filter != null) {
            this.filter.init(this.cursor, executionContext);
        }
        return this.cursor;
    }
}

