/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.FunctionBasedRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursor;
import io.questdb.std.IntList;

public class DeferredSymbolIndexFilteredRowCursorFactory
implements FunctionBasedRowCursorFactory {
    private final SymbolIndexFilteredRowCursor cursor;
    private final int columnIndex;
    private final Function symbolFunction;
    private int symbolKey = -2;

    public DeferredSymbolIndexFilteredRowCursorFactory(int columnIndex, Function symbolFunction, Function filter, boolean cachedIndexReaderCursor, int indexDirection, IntList columnIndexes) {
        this.columnIndex = columnIndex;
        this.symbolFunction = symbolFunction;
        this.cursor = new SymbolIndexFilteredRowCursor(columnIndex, filter, cachedIndexReaderCursor, indexDirection, columnIndexes);
    }

    @Override
    public RowCursor getCursor(DataFrame dataFrame) {
        if (this.symbolKey == -2) {
            return EmptyRowCursor.INSTANCE;
        }
        return this.cursor.of(dataFrame);
    }

    @Override
    public void prepareCursor(TableReader tableReader, SqlExecutionContext sqlExecutionContext) throws SqlException {
        this.symbolFunction.init(tableReader, sqlExecutionContext);
        this.symbolKey = tableReader.getSymbolMapReader(this.columnIndex).keyOf(this.symbolFunction.getStr(null));
        if (this.symbolKey != -2) {
            this.cursor.of(this.symbolKey);
            this.cursor.prepare(tableReader);
        }
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public boolean isUsingIndex() {
        return true;
    }

    @Override
    public Function getFunction() {
        return this.symbolFunction;
    }
}

