/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.vm.NullMemoryMR;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Rows;
import io.questdb.std.Unsafe;
import org.jetbrains.annotations.Nullable;

public class BwdTableReaderPageFrameCursor
implements PageFrameCursor {
    private final LongList columnPageNextAddress = new LongList();
    private final LongList columnPageAddress = new LongList();
    private final TableReaderPageFrame frame = new TableReaderPageFrame();
    private final LongList topsRemaining = new LongList();
    private final IntList pages = new IntList();
    private final int columnCount;
    private final LongList pageRowsRemaining = new LongList();
    private final LongList pageSizes = new LongList();
    private final int workerCount;
    private TableReader reader;
    private int reenterPartitionIndex;
    private long currentPageFrameRowLimit;
    private DataFrameCursor dataFrameCursor;
    private long reenterPartitionLo;
    private long reenterPartitionHi;
    private boolean reenterDataFrame = false;
    private final IntList columnIndexes;
    private final int pageFrameMinRows;
    private final int pageFrameMaxRows;
    private final IntList columnSizes;

    public BwdTableReaderPageFrameCursor(IntList columnIndexes, IntList columnSizes, int workerCount, int pageFrameMinRows, int pageFrameMaxRows) {
        this.columnIndexes = columnIndexes;
        this.columnSizes = columnSizes;
        this.columnCount = columnIndexes.size();
        this.workerCount = workerCount;
        this.pageFrameMinRows = pageFrameMinRows;
        this.pageFrameMaxRows = pageFrameMaxRows;
    }

    @Override
    public void close() {
        this.dataFrameCursor = Misc.free(this.dataFrameCursor);
    }

    @Override
    public long getUpdateRowId(long rowIndex) {
        return Rows.toRowID(this.frame.getPartitionIndex(), this.frame.getPartitionLo() + rowIndex);
    }

    @Override
    @Nullable
    public PageFrame next() {
        if (this.reenterDataFrame) {
            return this.computeFrame(this.reenterPartitionLo, this.reenterPartitionHi);
        }
        DataFrame dataFrame = this.dataFrameCursor.next();
        if (dataFrame != null) {
            this.reenterPartitionIndex = dataFrame.getPartitionIndex();
            long lo = dataFrame.getRowLo();
            long hi = dataFrame.getRowHi();
            this.currentPageFrameRowLimit = Math.min((long)this.pageFrameMaxRows, Math.max((long)this.pageFrameMinRows, (hi - lo) / (long)this.workerCount));
            return this.computeFrame(lo, hi);
        }
        return null;
    }

    @Override
    public void toTop() {
        this.dataFrameCursor.toTop();
        this.pages.setAll(this.columnCount, 0);
        this.topsRemaining.setAll(this.columnCount, 0L);
        this.columnPageAddress.setAll(this.columnCount * 2, 0L);
        this.columnPageNextAddress.setAll(this.columnCount * 2, 0L);
        this.pageRowsRemaining.setAll(this.columnCount, -1L);
        this.pageSizes.setAll(this.columnCount * 2, -1L);
        this.reenterDataFrame = false;
    }

    @Override
    public long size() {
        return this.reader.size();
    }

    @Override
    public StaticSymbolTable getSymbolTable(int columnIndex) {
        return this.reader.getSymbolTable(this.columnIndexes.getQuick(columnIndex));
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.reader.newSymbolTable(this.columnIndexes.getQuick(columnIndex));
    }

    public BwdTableReaderPageFrameCursor of(DataFrameCursor dataFrameCursor) {
        this.reader = dataFrameCursor.getTableReader();
        this.dataFrameCursor = dataFrameCursor;
        this.toTop();
        return this;
    }

    private TableReaderPageFrame computeFrame(long partitionLo, long partitionHi) {
        int columnIndex;
        int i;
        int base = this.reader.getColumnBase(this.reenterPartitionIndex);
        long adjustedLo = Math.max(partitionLo, partitionHi - this.currentPageFrameRowLimit);
        for (i = 0; i < this.columnCount; ++i) {
            columnIndex = this.columnIndexes.getQuick(i);
            long top = this.reader.getColumnTop(base, columnIndex);
            if (top <= adjustedLo || top >= partitionHi) continue;
            adjustedLo = top;
        }
        for (i = 0; i < this.columnCount; ++i) {
            columnIndex = this.columnIndexes.getQuick(i);
            int readerColIndex = TableReader.getPrimaryColumnIndex(base, columnIndex);
            MemoryR col = this.reader.getColumn(readerColIndex);
            long top = col instanceof NullMemoryMR ? partitionHi : this.reader.getColumnTop(base, columnIndex);
            long partitionLoAdjusted = adjustedLo - top;
            long partitionHiAdjusted = partitionHi - top;
            int sh = this.columnSizes.getQuick(i);
            if (partitionHiAdjusted > 0L) {
                if (sh > -1) {
                    long address = col.getPageAddress(0);
                    long addressSize = partitionHiAdjusted << sh;
                    long offset = partitionLoAdjusted << sh;
                    this.columnPageAddress.setQuick(i * 2, address + offset);
                    this.pageSizes.setQuick(i * 2, addressSize - offset);
                    continue;
                }
                MemoryR fixCol = this.reader.getColumn(readerColIndex + 1);
                long fixAddress = fixCol.getPageAddress(0);
                long fixAddressSize = partitionHiAdjusted << 3;
                long fixOffset = partitionLoAdjusted << 3;
                long varAddress = col.getPageAddress(0);
                long varAddressSize = Unsafe.getUnsafe().getLong(fixAddress + fixAddressSize);
                this.columnPageAddress.setQuick(i * 2, varAddress);
                this.columnPageAddress.setQuick(i * 2 + 1, fixAddress + fixOffset);
                this.pageSizes.setQuick(i * 2, varAddressSize);
                this.pageSizes.setQuick(i * 2 + 1, fixAddressSize - fixOffset);
                continue;
            }
            this.columnPageAddress.setQuick(i * 2, 0L);
            this.columnPageAddress.setQuick(i * 2 + 1, 0L);
            this.pageSizes.setQuick(i * 2, partitionHiAdjusted - partitionLoAdjusted << (sh > -1 ? sh : 3));
            this.pageSizes.setQuick(i * 2 + 1, 0L);
        }
        if (partitionLo < adjustedLo) {
            this.reenterPartitionLo = partitionLo;
            this.reenterPartitionHi = adjustedLo;
            this.reenterDataFrame = true;
        } else {
            this.reenterDataFrame = false;
        }
        this.frame.partitionLo = adjustedLo;
        this.frame.partitionHi = partitionHi;
        this.frame.partitionIndex = this.reenterPartitionIndex;
        return this.frame;
    }

    private class TableReaderPageFrame
    implements PageFrame {
        private long partitionLo;
        private long partitionHi;
        private int partitionIndex;

        private TableReaderPageFrame() {
        }

        @Override
        public void copyColumnAddressesTo(LongList destColumnAddresses) {
            destColumnAddresses.add(BwdTableReaderPageFrameCursor.this.columnPageAddress);
        }

        @Override
        public BitmapIndexReader getBitmapIndexReader(int columnIndex, int direction) {
            return BwdTableReaderPageFrameCursor.this.reader.getBitmapIndexReader(this.partitionIndex, BwdTableReaderPageFrameCursor.this.columnIndexes.getQuick(columnIndex), direction);
        }

        @Override
        public int getColumnShiftBits(int columnIndex) {
            return BwdTableReaderPageFrameCursor.this.columnSizes.getQuick(columnIndex);
        }

        @Override
        public long getPageAddress(int columnIndex) {
            return BwdTableReaderPageFrameCursor.this.columnPageAddress.getQuick(columnIndex * 2);
        }

        @Override
        public long getIndexPageAddress(int columnIndex) {
            return BwdTableReaderPageFrameCursor.this.columnPageAddress.getQuick(columnIndex * 2 + 1);
        }

        @Override
        public long getPageSize(int columnIndex) {
            return BwdTableReaderPageFrameCursor.this.pageSizes.getQuick(columnIndex * 2);
        }

        @Override
        public int getPartitionIndex() {
            return this.partitionIndex;
        }

        @Override
        public long getPartitionLo() {
            return this.partitionLo;
        }

        @Override
        public long getPartitionHi() {
            return this.partitionHi;
        }
    }
}

