/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.TableReaderSelectedColumnRecord;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDataFrameRecordCursor
implements RecordCursor {
    protected final TableReaderSelectedColumnRecord recordA;
    protected final TableReaderSelectedColumnRecord recordB;
    protected DataFrameCursor dataFrameCursor;
    protected final IntList columnIndexes;

    public AbstractDataFrameRecordCursor(@NotNull IntList columnIndexes) {
        this.columnIndexes = columnIndexes;
        this.recordA = new TableReaderSelectedColumnRecord(columnIndexes);
        this.recordB = new TableReaderSelectedColumnRecord(columnIndexes);
    }

    @Override
    public void close() {
        this.dataFrameCursor = Misc.free(this.dataFrameCursor);
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public StaticSymbolTable getSymbolTable(int columnIndex) {
        return this.dataFrameCursor.getSymbolTable(this.columnIndexes.getQuick(columnIndex));
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.dataFrameCursor.newSymbolTable(this.columnIndexes.getQuick(columnIndex));
    }

    @Override
    public Record getRecordB() {
        return this.recordB;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        ((TableReaderSelectedColumnRecord)record).jumpTo(Rows.toPartitionIndex(atRowId), Rows.toLocalRowID(atRowId));
    }

    abstract void of(DataFrameCursor var1, SqlExecutionContext var2) throws SqlException;
}

