/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.orderby.LongTreeChain;
import io.questdb.griffin.engine.orderby.SortedLightRecordCursor;

public class SortedLightRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final SortedLightRecordCursor cursor;

    public SortedLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory base, RecordComparator comparator) {
        super(metadata);
        LongTreeChain chain = new LongTreeChain(configuration.getSqlSortKeyPageSize(), configuration.getSqlSortKeyMaxPages(), configuration.getSqlSortLightValuePageSize(), configuration.getSqlSortLightValueMaxPages());
        this.base = base;
        this.cursor = new SortedLightRecordCursor(chain, comparator);
    }

    @Override
    protected void _close() {
        this.base.close();
        this.cursor.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.cursor.of(baseCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable ex) {
            baseCursor.close();
            this.cursor.close();
            throw ex;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }
}

