/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordChain;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.std.MemoryPages;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import java.io.Closeable;

public class RecordTreeChain
implements Closeable,
Mutable,
Reopenable {
    private static final int BLOCK_SIZE = 41;
    private static final int O_LEFT = 8;
    private static final int O_RIGHT = 16;
    private static final int O_COLOUR = 24;
    private static final int O_REF = 25;
    private static final int O_TOP = 33;
    private static final byte RED = 1;
    private static final byte BLACK = 0;
    private final RecordChain recordChain;
    private final Record recordChainRecord;
    private final MemoryPages mem;
    private final RecordComparator comparator;
    private final TreeCursor cursor = new TreeCursor();
    private long root = -1L;

    public RecordTreeChain(ColumnTypes columnTypes, RecordSink recordSink, RecordComparator comparator, long keyPageSize, int keyMaxPages, long valuePageSize, int valueMaxPages) {
        this.comparator = comparator;
        this.mem = new MemoryPages(keyPageSize, keyMaxPages);
        this.recordChain = new RecordChain(columnTypes, recordSink, valuePageSize, valueMaxPages);
        this.recordChainRecord = this.recordChain.getRecordB();
    }

    @Override
    public void reopen() {
        this.recordChain.reopen();
        this.mem.reopen();
    }

    private static void setLeft(long blockAddress, long left) {
        Unsafe.getUnsafe().putLong(blockAddress + 8L, left);
    }

    private static long rightOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 16L);
    }

    private static long leftOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 8L);
    }

    private static void setParent(long blockAddress, long parent) {
        Unsafe.getUnsafe().putLong(blockAddress, parent);
    }

    private static long refOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 25L);
    }

    private static long topOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 33L);
    }

    private static void setRef(long blockAddress, long recRef) {
        Unsafe.getUnsafe().putLong(blockAddress + 25L, recRef);
    }

    private static void setTop(long blockAddress, long recRef) {
        Unsafe.getUnsafe().putLong(blockAddress + 33L, recRef);
    }

    private static void setRight(long blockAddress, long right) {
        Unsafe.getUnsafe().putLong(blockAddress + 16L, right);
    }

    private static long parentOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress);
    }

    private static long parent2Of(long blockAddress) {
        return RecordTreeChain.parentOf(RecordTreeChain.parentOf(blockAddress));
    }

    private static void setColor(long blockAddress, byte colour) {
        if (blockAddress == -1L) {
            return;
        }
        Unsafe.getUnsafe().putByte(blockAddress + 24L, colour);
    }

    private static byte colorOf(long blockAddress) {
        return blockAddress == -1L ? (byte)0 : Unsafe.getUnsafe().getByte(blockAddress + 24L);
    }

    private static long successor(long current) {
        long p = RecordTreeChain.rightOf(current);
        if (p != -1L) {
            long l;
            while ((l = RecordTreeChain.leftOf(p)) != -1L) {
                p = l;
            }
        } else {
            p = RecordTreeChain.parentOf(current);
            long ch = current;
            while (p != -1L && ch == RecordTreeChain.rightOf(p)) {
                ch = p;
                p = RecordTreeChain.parentOf(p);
            }
        }
        return p;
    }

    @Override
    public void clear() {
        this.root = -1L;
        this.mem.clear();
        this.recordChain.clear();
    }

    @Override
    public void close() {
        this.root = -1L;
        Misc.free(this.recordChain);
        Misc.free(this.mem);
    }

    public TreeCursor getCursor(RecordCursor base) {
        this.cursor.of(base);
        return this.cursor;
    }

    public void put(Record record) {
        int cmp;
        long r;
        long parent;
        if (this.root == -1L) {
            this.putParent(record);
            return;
        }
        this.comparator.setLeft(record);
        long p = this.root;
        do {
            parent = p;
            r = RecordTreeChain.refOf(p);
            this.recordChain.recordAt(this.recordChainRecord, r);
            cmp = this.comparator.compare(this.recordChainRecord);
            if (cmp < 0) {
                p = RecordTreeChain.leftOf(p);
                continue;
            }
            if (cmp > 0) {
                p = RecordTreeChain.rightOf(p);
                continue;
            }
            RecordTreeChain.setRef(p, this.recordChain.put(record, r));
            return;
        } while (p > -1L);
        p = this.allocateBlock();
        RecordTreeChain.setParent(p, parent);
        r = this.recordChain.put(record, -1L);
        RecordTreeChain.setTop(p, r);
        RecordTreeChain.setRef(p, r);
        if (cmp < 0) {
            RecordTreeChain.setLeft(parent, p);
        } else {
            RecordTreeChain.setRight(parent, p);
        }
        this.fix(p);
    }

    private long allocateBlock() {
        long p = this.mem.allocate(41L);
        RecordTreeChain.setLeft(p, -1L);
        RecordTreeChain.setRight(p, -1L);
        RecordTreeChain.setColor(p, (byte)0);
        return p;
    }

    private void fix(long x) {
        RecordTreeChain.setColor(x, (byte)1);
        while (x != -1L && x != this.root && RecordTreeChain.colorOf(RecordTreeChain.parentOf(x)) == 1) {
            long y;
            if (RecordTreeChain.parentOf(x) == RecordTreeChain.leftOf(RecordTreeChain.parent2Of(x))) {
                y = RecordTreeChain.rightOf(RecordTreeChain.parent2Of(x));
                if (RecordTreeChain.colorOf(y) == 1) {
                    RecordTreeChain.setColor(RecordTreeChain.parentOf(x), (byte)0);
                    RecordTreeChain.setColor(y, (byte)0);
                    RecordTreeChain.setColor(RecordTreeChain.parent2Of(x), (byte)1);
                    x = RecordTreeChain.parent2Of(x);
                    continue;
                }
                if (x == RecordTreeChain.rightOf(RecordTreeChain.parentOf(x))) {
                    x = RecordTreeChain.parentOf(x);
                    this.rotateLeft(x);
                }
                RecordTreeChain.setColor(RecordTreeChain.parentOf(x), (byte)0);
                RecordTreeChain.setColor(RecordTreeChain.parent2Of(x), (byte)1);
                this.rotateRight(RecordTreeChain.parent2Of(x));
                continue;
            }
            y = RecordTreeChain.leftOf(RecordTreeChain.parent2Of(x));
            if (RecordTreeChain.colorOf(y) == 1) {
                RecordTreeChain.setColor(RecordTreeChain.parentOf(x), (byte)0);
                RecordTreeChain.setColor(y, (byte)0);
                RecordTreeChain.setColor(RecordTreeChain.parent2Of(x), (byte)1);
                x = RecordTreeChain.parent2Of(x);
                continue;
            }
            if (x == RecordTreeChain.leftOf(RecordTreeChain.parentOf(x))) {
                x = RecordTreeChain.parentOf(x);
                this.rotateRight(x);
            }
            RecordTreeChain.setColor(RecordTreeChain.parentOf(x), (byte)0);
            RecordTreeChain.setColor(RecordTreeChain.parent2Of(x), (byte)1);
            this.rotateLeft(RecordTreeChain.parent2Of(x));
        }
        RecordTreeChain.setColor(this.root, (byte)0);
    }

    private void putParent(Record record) {
        this.root = this.allocateBlock();
        long r = this.recordChain.put(record, -1L);
        RecordTreeChain.setTop(this.root, r);
        RecordTreeChain.setRef(this.root, r);
        RecordTreeChain.setParent(this.root, -1L);
        RecordTreeChain.setLeft(this.root, -1L);
        RecordTreeChain.setRight(this.root, -1L);
    }

    private void rotateLeft(long p) {
        if (p != -1L) {
            long r = RecordTreeChain.rightOf(p);
            RecordTreeChain.setRight(p, RecordTreeChain.leftOf(r));
            if (RecordTreeChain.leftOf(r) != -1L) {
                RecordTreeChain.setParent(RecordTreeChain.leftOf(r), p);
            }
            RecordTreeChain.setParent(r, RecordTreeChain.parentOf(p));
            if (RecordTreeChain.parentOf(p) == -1L) {
                this.root = r;
            } else if (RecordTreeChain.leftOf(RecordTreeChain.parentOf(p)) == p) {
                RecordTreeChain.setLeft(RecordTreeChain.parentOf(p), r);
            } else {
                RecordTreeChain.setRight(RecordTreeChain.parentOf(p), r);
            }
            RecordTreeChain.setLeft(r, p);
            RecordTreeChain.setParent(p, r);
        }
    }

    private void rotateRight(long p) {
        if (p != -1L) {
            long l = RecordTreeChain.leftOf(p);
            RecordTreeChain.setLeft(p, RecordTreeChain.rightOf(l));
            if (RecordTreeChain.rightOf(l) != -1L) {
                RecordTreeChain.setParent(RecordTreeChain.rightOf(l), p);
            }
            RecordTreeChain.setParent(l, RecordTreeChain.parentOf(p));
            if (RecordTreeChain.parentOf(p) == -1L) {
                this.root = l;
            } else if (RecordTreeChain.rightOf(RecordTreeChain.parentOf(p)) == p) {
                RecordTreeChain.setRight(RecordTreeChain.parentOf(p), l);
            } else {
                RecordTreeChain.setLeft(RecordTreeChain.parentOf(p), l);
            }
            RecordTreeChain.setRight(l, p);
            RecordTreeChain.setParent(p, l);
        }
    }

    public class TreeCursor
    implements RecordCursor {
        private long current;
        private RecordCursor base;

        @Override
        public void close() {
            this.base.close();
            this.current = -1L;
        }

        @Override
        public Record getRecord() {
            return RecordTreeChain.this.recordChain.getRecord();
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.base.getSymbolTable(columnIndex);
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.base.newSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            if (RecordTreeChain.this.recordChain.hasNext()) {
                return true;
            }
            this.current = RecordTreeChain.successor(this.current);
            if (this.current == -1L) {
                return false;
            }
            RecordTreeChain.this.recordChain.of(RecordTreeChain.topOf(this.current));
            return RecordTreeChain.this.recordChain.hasNext();
        }

        @Override
        public long size() {
            return this.base.size();
        }

        @Override
        public Record getRecordB() {
            return RecordTreeChain.this.recordChain.getRecordB();
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            RecordTreeChain.this.recordChain.recordAt(record, atRowId);
        }

        @Override
        public void toTop() {
            long p = RecordTreeChain.this.root;
            if (p != -1L) {
                while (RecordTreeChain.leftOf(p) != -1L) {
                    p = RecordTreeChain.leftOf(p);
                }
            }
            this.current = p;
            RecordTreeChain.this.recordChain.of(RecordTreeChain.topOf(this.current));
        }

        private void of(RecordCursor base) {
            this.base = base;
            RecordTreeChain.this.recordChain.setSymbolTableResolver(base);
            this.toTop();
        }
    }
}

