/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.orderby.LimitedSizeLongTreeChain;

public class LimitedSizeSortedLightRecordCursor
implements DelegatingRecordCursor {
    private final LimitedSizeLongTreeChain chain;
    private final RecordComparator comparator;
    private final LimitedSizeLongTreeChain.TreeCursor chainCursor;
    private RecordCursor base;
    private Record baseRecord;
    private final long limit;
    private final long skipFirst;
    private final long skipLast;
    private long rowsLeft;
    private boolean isOpen;

    public LimitedSizeSortedLightRecordCursor(LimitedSizeLongTreeChain chain, RecordComparator comparator, long limit, long skipFirst, long skipLast) {
        this.chain = chain;
        this.comparator = comparator;
        this.chainCursor = chain.getCursor();
        this.limit = limit;
        this.skipFirst = skipFirst;
        this.skipLast = skipLast;
        this.isOpen = true;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.chain.close();
            this.base.close();
            this.isOpen = false;
        }
    }

    @Override
    public long size() {
        return Math.max(this.chain.size() - this.skipFirst - this.skipLast, 0L);
    }

    @Override
    public Record getRecord() {
        return this.baseRecord;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.base.getSymbolTable(columnIndex);
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.base.newSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        if (this.rowsLeft-- > 0L && this.chainCursor.hasNext()) {
            this.base.recordAt(this.baseRecord, this.chainCursor.next());
            return true;
        }
        return false;
    }

    @Override
    public Record getRecordB() {
        return this.base.getRecordB();
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.base.recordAt(record, atRowId);
    }

    @Override
    public void toTop() {
        this.chainCursor.toTop();
        long skipLeft = this.skipFirst;
        while (skipLeft-- > 0L && this.chainCursor.hasNext()) {
            this.chainCursor.next();
        }
        this.rowsLeft = Math.max(this.chain.size() - this.skipFirst - this.skipLast, 0L);
    }

    @Override
    public void of(RecordCursor base, SqlExecutionContext executionContext) throws SqlException {
        if (!this.isOpen) {
            this.chain.reopen();
            this.isOpen = true;
        }
        this.base = base;
        this.baseRecord = base.getRecord();
        Record placeHolderRecord = base.getRecordB();
        SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
        this.chain.clear();
        if (this.limit != 0L) {
            while (base.hasNext()) {
                circuitBreaker.statefulThrowExceptionIfTripped();
                this.chain.put(this.baseRecord, base, placeHolderRecord, this.comparator);
            }
        }
        this.toTop();
    }
}

