/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.AbstractOperation;
import io.questdb.griffin.engine.ops.DoneOperationFuture;
import io.questdb.griffin.engine.ops.OperationFutureImpl;
import io.questdb.mp.SCSequence;
import io.questdb.std.WeakSelfReturningObjectPool;
import org.jetbrains.annotations.Nullable;

public class OperationDispatcher<T extends AbstractOperation> {
    private final CairoEngine engine;
    private final DoneOperationFuture doneFuture = new DoneOperationFuture();
    private final WeakSelfReturningObjectPool<OperationFutureImpl> futurePool;
    private final CharSequence lockReason;

    public OperationDispatcher(CairoEngine engine, CharSequence lockReason) {
        this.engine = engine;
        this.futurePool = new WeakSelfReturningObjectPool<OperationFutureImpl>(pool -> new OperationFutureImpl(engine, pool), 2);
        this.lockReason = lockReason;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OperationFuture execute(T operation, SqlExecutionContext sqlExecutionContext, @Nullable SCSequence eventSubSeq) throws SqlException {
        ((AbstractOperation)operation).withContext(sqlExecutionContext);
        try (TableWriter writer = this.engine.getWriter(sqlExecutionContext.getCairoSecurityContext(), ((AbstractOperation)operation).getTableName(), this.lockReason);){
            OperationFuture operationFuture = this.doneFuture.of(operation.apply(writer, true));
            return operationFuture;
        }
        catch (EntryUnavailableException busyException) {
            if (eventSubSeq != null) return ((OperationFutureImpl)this.futurePool.pop()).of((AsyncWriterCommand)operation, sqlExecutionContext, eventSubSeq, ((AbstractOperation)operation).getTableNamePosition());
            throw busyException;
        }
    }
}

