/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.QuietClosable;
import io.questdb.tasks.TableWriterTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractOperation
implements AsyncWriterCommand,
QuietClosable {
    static final long NO_CORRELATION_ID = -1L;
    private int cmdType;
    private String cmdName;
    private int tableId;
    private long tableVersion;
    private long correlationId;
    String tableName;
    int tableNamePosition;
    @Nullable
    SqlExecutionContext sqlExecutionContext;

    void init(int cmdType, String cmdName, String tableName, int tableId, long tableVersion, int tableNamePosition) {
        this.cmdType = cmdType;
        this.cmdName = cmdName;
        this.tableName = tableName;
        this.tableId = tableId;
        this.tableVersion = tableVersion;
        this.tableNamePosition = tableNamePosition;
        this.correlationId = -1L;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    @Override
    public long getTableVersion() {
        return this.tableVersion;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getCommandName() {
        return this.cmdName;
    }

    @Override
    public int getTableNamePosition() {
        return this.tableNamePosition;
    }

    @Override
    public long getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public void setCommandCorrelationId(long correlationId) {
        this.correlationId = correlationId;
    }

    public void clearCommandCorrelationId() {
        this.setCommandCorrelationId(-1L);
    }

    @Override
    public void serialize(TableWriterTask task) {
        task.of(this.cmdType, this.tableId, this.tableName);
        task.setInstance(this.correlationId);
    }

    public void withContext(@NotNull SqlExecutionContext sqlExecutionContext) {
        assert (sqlExecutionContext != null);
        this.sqlExecutionContext = sqlExecutionContext;
    }

    @Override
    public void close() {
    }
}

