/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.Reopenable;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.std.Mutable;
import java.io.Closeable;

public class LongChain
implements Closeable,
Mutable,
Reopenable {
    private final MemoryARW valueChain;
    private final TreeCursor cursor;

    public LongChain(long valuePageSize, int valueMaxPages) {
        this.valueChain = Vm.getARWInstance(valuePageSize, valueMaxPages, 1);
        this.cursor = new TreeCursor();
    }

    @Override
    public void clear() {
        this.valueChain.jumpTo(0L);
    }

    @Override
    public void close() {
        this.valueChain.close();
    }

    public TreeCursor getCursor(long tailOffset) {
        this.cursor.of(tailOffset);
        return this.cursor;
    }

    @Override
    public void reopen() {
    }

    public long put(long value, long parentOffset) {
        long appendOffset = this.valueChain.getAppendOffset();
        if (parentOffset != -1L) {
            this.valueChain.putLong(parentOffset, appendOffset);
        }
        this.valueChain.putLongLong(-1L, value);
        return appendOffset;
    }

    public class TreeCursor {
        private long nextOffset;

        public boolean hasNext() {
            return this.nextOffset != -1L;
        }

        public long next() {
            long next = LongChain.this.valueChain.getLong(this.nextOffset);
            long value = LongChain.this.valueChain.getLong(this.nextOffset + 8L);
            this.nextOffset = next;
            return value;
        }

        void of(long startOffset) {
            this.nextOffset = startOffset;
        }
    }
}

