/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordChain;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.HashOuterJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.JoinRecord;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.std.Misc;

public class HashJoinRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory masterFactory;
    private final RecordCursorFactory slaveFactory;
    private final RecordSink masterSink;
    private final RecordSink slaveKeySink;
    private final HashJoinRecordCursor cursor;

    public HashJoinRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterSink, RecordSink slaveKeySink, RecordSink slaveChainSink, int columnSplit) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        Map joinKeyMap = MapFactory.createMap(configuration, joinColumnTypes, valueTypes);
        RecordChain slaveChain = new RecordChain(slaveFactory.getMetadata(), slaveChainSink, configuration.getSqlHashJoinValuePageSize(), configuration.getSqlHashJoinValueMaxPages());
        this.masterSink = masterSink;
        this.slaveKeySink = slaveKeySink;
        this.cursor = new HashJoinRecordCursor(columnSplit, joinKeyMap, slaveChain);
    }

    @Override
    protected void _close() {
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
        this.cursor.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor slaveCursor = this.slaveFactory.getCursor(executionContext);
        try {
            this.cursor.of(executionContext, slaveCursor);
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(this.cursor);
            throw e;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public boolean hasDescendingOrder() {
        return this.masterFactory.hasDescendingOrder();
    }

    @Override
    public boolean supportsUpdateRowId(CharSequence tableName) {
        return this.masterFactory.supportsUpdateRowId(tableName);
    }

    private class HashJoinRecordCursor
    extends AbstractJoinCursor {
        private final JoinRecord recordA;
        private final RecordChain slaveChain;
        private final Map joinKeyMap;
        private Record masterRecord;
        private boolean useSlaveCursor;
        private boolean isOpen;

        public HashJoinRecordCursor(int columnSplit, Map joinKeyMap, RecordChain slaveChain) {
            super(columnSplit);
            this.recordA = new JoinRecord(columnSplit);
            this.joinKeyMap = joinKeyMap;
            this.slaveChain = slaveChain;
            this.isOpen = true;
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public boolean hasNext() {
            if (this.useSlaveCursor && this.slaveChain.hasNext()) {
                return true;
            }
            while (this.masterCursor.hasNext()) {
                MapKey key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, HashJoinRecordCursorFactory.this.masterSink);
                MapValue value = key.findValue();
                if (value == null) continue;
                this.slaveChain.of(value.getLong(0));
                this.slaveChain.hasNext();
                this.useSlaveCursor = true;
                return true;
            }
            return false;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.useSlaveCursor = false;
        }

        private void buildMapOfSlaveRecords(RecordCursor slaveCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.joinKeyMap.reopen();
                this.slaveChain.reopen();
            }
            HashJoinRecordCursorFactory factory = HashJoinRecordCursorFactory.this;
            HashOuterJoinRecordCursorFactory.buildMap(slaveCursor, slaveCursor.getRecord(), this.joinKeyMap, factory.slaveKeySink, this.slaveChain, circuitBreaker);
        }

        void of(SqlExecutionContext executionContext, RecordCursor slaveCursor) throws SqlException {
            try {
                this.buildMapOfSlaveRecords(slaveCursor, executionContext.getCircuitBreaker());
                this.masterCursor = HashJoinRecordCursorFactory.this.masterFactory.getCursor(executionContext);
                this.slaveCursor = slaveCursor;
                this.masterRecord = this.masterCursor.getRecord();
                Record slaveRecord = this.slaveChain.getRecord();
                this.slaveChain.setSymbolTableResolver(slaveCursor);
                this.recordA.of(this.masterRecord, slaveRecord);
                this.useSlaveCursor = false;
            }
            catch (Throwable e) {
                this.masterCursor = Misc.free(this.masterCursor);
                throw e;
            }
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.joinKeyMap.close();
                this.slaveChain.close();
                super.close();
            }
        }
    }
}

