/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.std.Misc;

public class AsOfJoinLightRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory masterFactory;
    private final RecordCursorFactory slaveFactory;
    private final RecordSink masterKeySink;
    private final RecordSink slaveKeySink;
    private final AsOfLightJoinRecordCursor cursor;

    public AsOfJoinLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.masterKeySink = masterKeySink;
        this.slaveKeySink = slaveKeySink;
        Map joinKeyMap = MapFactory.createMap(configuration, joinColumnTypes, valueTypes);
        this.cursor = new AsOfLightJoinRecordCursor(columnSplit, joinKeyMap, NullRecordFactory.getInstance(slaveFactory.getMetadata()), masterFactory.getMetadata().getTimestampIndex(), slaveFactory.getMetadata().getTimestampIndex());
    }

    @Override
    protected void _close() {
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
        this.cursor.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor master = this.masterFactory.getCursor(executionContext);
        RecordCursor slave = null;
        try {
            slave = this.slaveFactory.getCursor(executionContext);
            this.cursor.of(master, slave);
        }
        catch (Throwable ex) {
            Misc.free(master);
            Misc.free(slave);
            throw ex;
        }
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public boolean hasDescendingOrder() {
        return this.masterFactory.hasDescendingOrder();
    }

    private class AsOfLightJoinRecordCursor
    extends AbstractJoinCursor {
        private final OuterJoinRecord record;
        private final Map joinKeyMap;
        private final int masterTimestampIndex;
        private final int slaveTimestampIndex;
        private Record slaveRecord;
        private Record masterRecord;
        private long slaveTimestamp;
        private long lastSlaveRowID;
        private boolean isOpen;

        public AsOfLightJoinRecordCursor(int columnSplit, Map joinKeyMap, Record nullRecord, int masterTimestampIndex, int slaveTimestampIndex) {
            super(columnSplit);
            this.slaveTimestamp = Long.MIN_VALUE;
            this.lastSlaveRowID = Long.MIN_VALUE;
            this.record = new OuterJoinRecord(columnSplit, nullRecord);
            this.joinKeyMap = joinKeyMap;
            this.masterTimestampIndex = masterTimestampIndex;
            this.slaveTimestampIndex = slaveTimestampIndex;
            this.isOpen = true;
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (this.masterCursor.hasNext()) {
                MapValue value;
                MapKey key;
                long slaveTimestamp = this.slaveTimestamp;
                long masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
                if (slaveTimestamp <= masterTimestamp) {
                    if (this.lastSlaveRowID != Long.MIN_VALUE) {
                        this.slaveCursor.recordAt(this.slaveRecord, this.lastSlaveRowID);
                        key = this.joinKeyMap.withKey();
                        key.put(this.slaveRecord, AsOfJoinLightRecordCursorFactory.this.slaveKeySink);
                        value = key.createValue();
                        value.putLong(0, this.lastSlaveRowID);
                    }
                    Record rec = this.slaveCursor.getRecord();
                    while (this.slaveCursor.hasNext() && (slaveTimestamp = rec.getTimestamp(this.slaveTimestampIndex)) <= masterTimestamp) {
                        key = this.joinKeyMap.withKey();
                        key.put(rec, AsOfJoinLightRecordCursorFactory.this.slaveKeySink);
                        value = key.createValue();
                        value.putLong(0, rec.getRowId());
                    }
                    this.slaveTimestamp = slaveTimestamp;
                    this.lastSlaveRowID = rec.getRowId();
                }
                key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, AsOfJoinLightRecordCursorFactory.this.masterKeySink);
                value = key.findValue();
                if (value != null) {
                    this.slaveCursor.recordAt(this.slaveRecord, value.getLong(0));
                    this.record.hasSlave(true);
                } else {
                    this.record.hasSlave(false);
                }
                return true;
            }
            return false;
        }

        @Override
        public void toTop() {
            this.joinKeyMap.clear();
            this.slaveTimestamp = Long.MIN_VALUE;
            this.lastSlaveRowID = Long.MIN_VALUE;
            this.masterCursor.toTop();
            this.slaveCursor.toTop();
        }

        @Override
        public long size() {
            return this.masterCursor.size();
        }

        void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.joinKeyMap.reopen();
            }
            this.slaveTimestamp = Long.MIN_VALUE;
            this.lastSlaveRowID = Long.MIN_VALUE;
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecord = slaveCursor.getRecordB();
            this.record.of(this.masterRecord, this.slaveRecord);
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.joinKeyMap.close();
                super.close();
            }
        }
    }
}

