/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.mp.CountDownLatchSPI;
import io.questdb.std.AbstractLockable;
import io.questdb.std.Mutable;
import io.questdb.std.Rosti;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class VectorAggregateEntry
extends AbstractLockable
implements Mutable {
    private long[] pRosti;
    private long keyAddress;
    private long valueAddress;
    private long valueCount;
    private int columnSizeShr;
    private VectorAggregateFunction func;
    private CountDownLatchSPI doneLatch;
    private AtomicInteger oomCounter;

    @Override
    public void clear() {
        this.valueAddress = 0L;
        this.valueCount = 0L;
        this.func = null;
    }

    public boolean run(int workerId) {
        if (this.tryLock()) {
            if (this.pRosti != null) {
                long oldSize = Rosti.getAllocMemory(this.pRosti[workerId]);
                if (!this.func.aggregate(this.pRosti[workerId], this.keyAddress, this.valueAddress, this.valueCount, this.columnSizeShr, workerId)) {
                    this.oomCounter.incrementAndGet();
                }
                Rosti.updateMemoryUsage(this.pRosti[workerId], oldSize);
            } else {
                this.func.aggregate(this.valueAddress, this.valueCount, this.columnSizeShr, workerId);
            }
            this.doneLatch.countDown();
            return true;
        }
        return false;
    }

    void of(int sequence, VectorAggregateFunction vaf, long[] pRosti, long keyPageAddress, long valuePageAddress, long valuePageCount, int columnSizeShr, CountDownLatchSPI doneLatch, @Nullable AtomicInteger oomCounter) {
        this.of(sequence);
        this.pRosti = pRosti;
        this.keyAddress = keyPageAddress;
        this.valueAddress = valuePageAddress;
        this.valueCount = valuePageCount;
        this.func = vaf;
        this.columnSizeShr = columnSizeShr;
        this.doneLatch = doneLatch;
        this.oomCounter = oomCounter;
    }
}

