/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.MessageBus;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.VirtualRecordNoRowid;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateEntry;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.mp.Sequence;
import io.questdb.mp.Worker;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.tasks.VectorAggregateTask;

public class GroupByNotKeyedVectorRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final Log LOG = LogFactory.getLog(GroupByNotKeyedVectorRecordCursorFactory.class);
    private final RecordCursorFactory base;
    private final ObjList<VectorAggregateFunction> vafList;
    private final ObjectPool<VectorAggregateEntry> entryPool;
    private final ObjList<VectorAggregateEntry> activeEntries;
    private final SOUnboundedCountDownLatch doneLatch = new SOUnboundedCountDownLatch();
    private final GroupByNotKeyedVectorRecordCursor cursor;

    public GroupByNotKeyedVectorRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, RecordMetadata metadata, ObjList<VectorAggregateFunction> vafList) {
        super(metadata);
        this.entryPool = new ObjectPool<VectorAggregateEntry>(VectorAggregateEntry::new, configuration.getGroupByPoolCapacity());
        this.activeEntries = new ObjList(configuration.getGroupByPoolCapacity());
        this.base = base;
        this.vafList = new ObjList(vafList.size());
        this.vafList.addAll(vafList);
        this.cursor = new GroupByNotKeyedVectorRecordCursor(this.vafList);
    }

    @Override
    protected void _close() {
        Misc.freeObjList(this.vafList);
        Misc.free(this.base);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        PageFrame frame;
        MessageBus bus = executionContext.getMessageBus();
        PageFrameCursor cursor = this.base.getPageFrameCursor(executionContext, 0);
        int vafCount = this.vafList.size();
        for (int i = 0; i < vafCount; ++i) {
            this.vafList.getQuick(i).clear();
        }
        RingQueue<VectorAggregateTask> queue = bus.getVectorAggregateQueue();
        Sequence pubSeq = bus.getVectorAggregatePubSeq();
        this.entryPool.clear();
        this.activeEntries.clear();
        int queuedCount = 0;
        int ownCount = 0;
        int reclaimed = 0;
        int total = 0;
        this.doneLatch.reset();
        Thread thread = Thread.currentThread();
        int workerId = thread instanceof Worker ? ((Worker)thread).getWorkerId() : 0;
        while ((frame = cursor.next()) != null) {
            for (int i = 0; i < vafCount; ++i) {
                VectorAggregateFunction vaf = this.vafList.getQuick(i);
                int columnIndex = vaf.getColumnIndex();
                long pageAddress = columnIndex > -1 ? frame.getPageAddress(columnIndex) : 0L;
                long pageSize = columnIndex > -1 ? frame.getPageSize(columnIndex) : frame.getPageSize(0);
                int colSizeShr = columnIndex > -1 ? frame.getColumnShiftBits(columnIndex) : frame.getColumnShiftBits(0);
                long seq = pubSeq.next();
                if (seq < 0L) {
                    vaf.aggregate(pageAddress, pageSize, colSizeShr, workerId);
                    ++ownCount;
                } else {
                    VectorAggregateEntry entry = this.entryPool.next();
                    entry.of(queuedCount++, vaf, null, 0L, pageAddress, pageSize, colSizeShr, this.doneLatch, null);
                    this.activeEntries.add(entry);
                    queue.get((long)seq).entry = entry;
                    pubSeq.done(seq);
                }
                ++total;
            }
        }
        reclaimed = GroupByNotKeyedVectorRecordCursorFactory.getRunWhatsLeft(queuedCount, reclaimed, workerId, this.activeEntries, this.doneLatch, LOG);
        LOG.info().$("done [total=").$(total).$(", ownCount=").$(ownCount).$(", reclaimed=").$(reclaimed).$(", queuedCount=").$(queuedCount).$(']').$();
        return this.cursor.of(cursor);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    static int getRunWhatsLeft(int queuedCount, int reclaimed, int workerId, ObjList<VectorAggregateEntry> activeEntries, SOUnboundedCountDownLatch doneLatch, Log log) {
        for (int i = activeEntries.size() - 1; i > -1 && doneLatch.getCount() > -queuedCount; --i) {
            if (!activeEntries.getQuick(i).run(workerId)) continue;
            ++reclaimed;
        }
        log.info().$("waiting for parts [queuedCount=").$(queuedCount).$(']').$();
        doneLatch.await(queuedCount);
        return reclaimed;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("GroupByNotKeyed");
        sink.meta("vectorized").val(true);
        sink.attr("groupByFunctions").val(this.vafList);
        sink.child(this.base);
    }

    private static class GroupByNotKeyedVectorRecordCursor
    implements NoRandomAccessRecordCursor {
        private final Record recordA;
        private int countDown = 1;
        private PageFrameCursor pageFrameCursor;

        public GroupByNotKeyedVectorRecordCursor(ObjList<? extends Function> functions) {
            this.recordA = new VirtualRecordNoRowid(functions);
        }

        @Override
        public void close() {
            Misc.free(this.pageFrameCursor);
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public boolean hasNext() {
            return this.countDown-- > 0;
        }

        @Override
        public void toTop() {
            this.countDown = 1;
        }

        @Override
        public long size() {
            return 1L;
        }

        private GroupByNotKeyedVectorRecordCursor of(PageFrameCursor pageFrameCursor) {
            this.pageFrameCursor = pageFrameCursor;
            this.toTop();
            return this;
        }
    }
}

