/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.map.MapValue;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Long256Util;

public class SimpleMapValue
implements MapValue {
    private final Long256Impl long256 = new Long256Impl();
    private final long[] values;

    public SimpleMapValue(int columnCount) {
        this.values = new long[4 * columnCount];
    }

    public void copy(SimpleMapValue other) {
        assert (this.values.length >= other.values.length);
        System.arraycopy(other.values, 0, this.values, 0, other.values.length);
    }

    @Override
    public long getAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBool(int index) {
        return this.values[4 * index] == 0L;
    }

    @Override
    public byte getByte(int index) {
        return (byte)this.values[4 * index];
    }

    @Override
    public long getDate(int index) {
        return this.values[4 * index];
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.values[4 * index]);
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat((int)this.values[4 * index]);
    }

    @Override
    public char getChar(int index) {
        return (char)this.values[4 * index];
    }

    @Override
    public int getInt(int index) {
        return (int)this.values[4 * index];
    }

    @Override
    public long getLong(int index) {
        return this.values[4 * index];
    }

    @Override
    public short getShort(int index) {
        return (short)this.values[4 * index];
    }

    @Override
    public long getTimestamp(int index) {
        return this.values[4 * index];
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public void putBool(int index, boolean value) {
        this.values[4 * index] = value ? 0L : 1L;
    }

    @Override
    public void putByte(int index, byte value) {
        this.values[4 * index] = value;
    }

    @Override
    public void addByte(int index, byte value) {
        int n = 4 * index;
        this.values[n] = this.values[n] + (long)value;
    }

    @Override
    public void putDate(int index, long value) {
        this.values[4 * index] = value;
    }

    @Override
    public void putDouble(int index, double value) {
        this.values[4 * index] = Double.doubleToLongBits(value);
    }

    @Override
    public void addDouble(int index, double value) {
        double d = Double.longBitsToDouble(this.values[4 * index]);
        this.values[4 * index] = Double.doubleToLongBits(value + d);
    }

    @Override
    public void putFloat(int index, float value) {
        this.values[4 * index] = Float.floatToIntBits(value);
    }

    @Override
    public void addFloat(int index, float value) {
        float d = Float.intBitsToFloat((int)this.values[4 * index]);
        this.values[4 * index] = Float.floatToIntBits(value + d);
    }

    @Override
    public void putInt(int index, int value) {
        this.values[4 * index] = value;
    }

    @Override
    public void addInt(int index, int value) {
        int n = 4 * index;
        this.values[n] = this.values[n] + (long)value;
    }

    @Override
    public void putLong(int index, long value) {
        this.values[4 * index] = value;
    }

    @Override
    public void addLong(int index, long value) {
        int n = 4 * index;
        this.values[n] = this.values[n] + value;
    }

    @Override
    public void putShort(int index, short value) {
        this.values[4 * index] = value;
    }

    @Override
    public void addShort(int index, short value) {
        int n = 4 * index;
        this.values[n] = this.values[n] + (long)value;
    }

    @Override
    public void putChar(int index, char value) {
        this.values[4 * index] = value;
    }

    @Override
    public void putTimestamp(int index, long value) {
        this.values[4 * index] = value;
    }

    @Override
    public void addLong256(int index, Long256 value) {
        Long256 acc = this.getLong256A(index);
        Long256Util.add(acc, value);
        int idx = 4 * index;
        this.values[idx] = acc.getLong0();
        this.values[idx + 1] = acc.getLong1();
        this.values[idx + 2] = acc.getLong2();
        this.values[idx + 3] = acc.getLong3();
    }

    @Override
    public void putLong256(int index, Long256 value) {
        int idx = 4 * index;
        this.values[idx] = value.getLong0();
        this.values[idx + 1] = value.getLong1();
        this.values[idx + 2] = value.getLong2();
        this.values[idx + 3] = value.getLong3();
    }

    @Override
    public Long256 getLong256A(int index) {
        int idx = 4 * index;
        this.long256.setAll(this.values[idx], this.values[idx + 1], this.values[idx + 2], this.values[idx + 3]);
        return this.long256;
    }

    @Override
    public byte getGeoByte(int col) {
        return (byte)this.values[4 * col];
    }

    @Override
    public void setMapRecordHere() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getGeoShort(int col) {
        return (short)this.values[4 * col];
    }

    @Override
    public int getGeoInt(int col) {
        return (int)this.values[4 * col];
    }

    @Override
    public long getGeoLong(int col) {
        return this.values[4 * col];
    }
}

