/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Misc;

public class DistinctSymbolRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final DistinctSymbolRecordCursor cursor;
    private final String tableName;
    private final long tableVersion;
    private final int tableId;

    public DistinctSymbolRecordCursorFactory(GenericRecordMetadata metadata, String tableName, int columnIndex, int tableId, long tableVersion) {
        super(metadata);
        this.tableName = tableName;
        this.tableVersion = tableVersion;
        this.tableId = tableId;
        this.cursor = new DistinctSymbolRecordCursor(columnIndex);
    }

    @Override
    protected void _close() {
        Misc.free(this.cursor);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        TableReader reader = executionContext.getCairoEngine().getReader(executionContext.getCairoSecurityContext(), this.tableName, this.tableId, this.tableVersion);
        this.cursor.of(reader);
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    private static class DistinctSymbolRecordCursor
    implements RecordCursor {
        private final DistinctSymbolRecord recordA = new DistinctSymbolRecord();
        private DistinctSymbolRecord recordB = null;
        private TableReader reader;
        private int numberOfSymbols;
        private SymbolMapReader symbolMapReader;
        private final int columnIndex;

        public DistinctSymbolRecordCursor(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public void close() {
            this.reader = Misc.free(this.reader);
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.symbolMapReader;
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.reader.newSymbolTable(this.columnIndex);
        }

        @Override
        public boolean hasNext() {
            if (this.recordA.getAndIncrementRecordIndex() < (long)this.numberOfSymbols) {
                return true;
            }
            this.recordA.decrementRecordIndex();
            return false;
        }

        @Override
        public Record getRecordB() {
            if (this.recordB == null) {
                this.recordB = new DistinctSymbolRecord();
            }
            this.recordB.reset();
            return this.recordB;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            ((DistinctSymbolRecord)record).recordIndex = (int)atRowId;
        }

        @Override
        public void toTop() {
            this.recordA.reset();
        }

        public void of(TableReader reader) {
            this.reader = reader;
            this.symbolMapReader = reader.getSymbolMapReader(this.columnIndex);
            this.numberOfSymbols = this.symbolMapReader.getSymbolCount() + (this.symbolMapReader.containsNullValue() ? 1 : 0);
            this.recordA.reset();
        }

        @Override
        public long size() {
            return this.numberOfSymbols;
        }

        public class DistinctSymbolRecord
        implements Record {
            private int recordIndex = -1;

            public void decrementRecordIndex() {
                --this.recordIndex;
            }

            @Override
            public CharSequence getSym(int col) {
                return DistinctSymbolRecordCursor.this.symbolMapReader.valueOf(this.recordIndex);
            }

            @Override
            public CharSequence getSymB(int col) {
                return DistinctSymbolRecordCursor.this.symbolMapReader.valueBOf(this.recordIndex);
            }

            @Override
            public int getInt(int col) {
                return this.recordIndex;
            }

            @Override
            public CharSequence getStr(int col) {
                return this.getSym(col);
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getSym(col);
            }

            @Override
            public int getStrLen(int col) {
                return this.getSym(col).length();
            }

            @Override
            public long getRowId() {
                return this.recordIndex;
            }

            public void reset() {
                this.recordIndex = -1;
            }

            public long getAndIncrementRecordIndex() {
                return ++this.recordIndex;
            }
        }
    }
}

