/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.test;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import java.util.concurrent.atomic.AtomicInteger;

public class TestLatchedCounterFunctionFactory
implements FunctionFactory {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static volatile Callback CALLBACK;

    public static int getCount() {
        return COUNTER.get();
    }

    public static void reset(Callback callback) {
        CALLBACK = callback;
        COUNTER.set(0);
    }

    @Override
    public String getSignature() {
        return "test_latched_counter()";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new TestLatchFunction();
    }

    static /* synthetic */ Callback access$000() {
        return CALLBACK;
    }

    private static class TestLatchFunction
    extends BooleanFunction {
        private final Callback callback = TestLatchedCounterFunctionFactory.access$000();

        @Override
        public void close() {
            if (null != this.callback) {
                this.callback.onClose();
            }
        }

        @Override
        public boolean getBool(Record rec) {
            int count = COUNTER.incrementAndGet();
            if (null == this.callback) {
                return true;
            }
            return this.callback.onGet(rec, count);
        }

        @Override
        public boolean isReadThreadSafe() {
            return true;
        }
    }

    public static interface Callback {
        default public void onClose() {
        }

        default public boolean onGet(Record rec, int count) {
            return true;
        }
    }
}

