/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Files;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class TouchTableFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "touch(C)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function function = args.get(0);
        int pos = argPositions.get(0);
        RecordCursorFactory recordCursorFactory = function.getRecordCursorFactory();
        if (recordCursorFactory == null || !recordCursorFactory.supportPageFrameCursor()) {
            throw SqlException.$(pos, "query does not support framing execution and cannot be pre-touched");
        }
        return new TouchTableFunc(function);
    }

    private static class TouchTableFunc
    extends StrFunction
    implements UnaryFunction {
        private static final Log LOG = LogFactory.getLog(TouchTableFunc.class);
        private final Function arg;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();
        private SqlExecutionContext sqlExecutionContext;
        private long garbage = 0L;
        private long dataPages = 0L;
        private long indexKeyPages = 0L;
        private long indexValuePages = 0L;

        public TouchTableFunc(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public CharSequence getStr(Record rec) {
            this.sinkA.clear();
            this.getStr(rec, this.sinkA);
            return this.sinkA;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            this.sinkB.clear();
            this.getStr(rec, this.sinkB);
            return this.sinkB;
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            this.touchTable();
            sink.put("{\"data_pages\": ").put(this.dataPages).put(", \"index_key_pages\":").put(this.indexKeyPages).put(", \"index_values_pages\": ").put(this.indexValuePages).put("}");
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.arg.init(symbolTableSource, executionContext);
            this.sqlExecutionContext = executionContext;
        }

        private void clearCounters() {
            this.garbage = 0L;
            this.dataPages = 0L;
            this.indexKeyPages = 0L;
            this.indexValuePages = 0L;
        }

        private long touchMemory(long pageSize, long baseAddress, long memorySize) {
            long pageCount = (memorySize + pageSize - 1L) / pageSize;
            for (long i = 0L; i < pageCount; ++i) {
                byte v = Unsafe.getUnsafe().getByte(baseAddress + i * pageSize);
                this.garbage += (long)v;
            }
            return pageCount;
        }

        private void touchTable() {
            this.clearCounters();
            long pageSize = Files.PAGE_SIZE;
            RecordCursorFactory recordCursorFactory = this.arg.getRecordCursorFactory();
            try (PageFrameCursor pageFrameCursor = recordCursorFactory.getPageFrameCursor(this.sqlExecutionContext, 0);){
                PageFrame frame;
                RecordMetadata metadata = recordCursorFactory.getMetadata();
                while ((frame = pageFrameCursor.next()) != null) {
                    int sz = metadata.getColumnCount();
                    for (int columnIndex = 0; columnIndex < sz; ++columnIndex) {
                        long columnMemorySize = frame.getPageSize(columnIndex);
                        long columnBaseAddress = frame.getPageAddress(columnIndex);
                        this.dataPages += this.touchMemory(pageSize, columnBaseAddress, columnMemorySize);
                        if (!metadata.isColumnIndexed(columnIndex)) continue;
                        BitmapIndexReader indexReader = frame.getBitmapIndexReader(columnIndex, 2);
                        long keyBaseAddress = indexReader.getKeyBaseAddress();
                        long keyMemorySize = indexReader.getKeyMemorySize();
                        this.indexKeyPages += this.touchMemory(pageSize, keyBaseAddress, keyMemorySize);
                        long valueBaseAddress = indexReader.getValueBaseAddress();
                        long valueMemorySize = indexReader.getValueMemorySize();
                        this.indexValuePages += this.touchMemory(pageSize, valueBaseAddress, valueMemorySize);
                    }
                }
            }
            catch (SqlException e) {
                LOG.error().$("cannot acquire page frame cursor: ").$(e).$();
            }
        }
    }
}

