/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public class SubStringFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "substring(SII)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function strFunc = args.getQuick(0);
        Function startFunc = args.getQuick(1);
        Function lenFunc = args.getQuick(2);
        if (strFunc.isNullConstant() || startFunc.isConstant() && startFunc.getInt(null) == Integer.MIN_VALUE || lenFunc.isConstant() && lenFunc.getInt(null) == Integer.MIN_VALUE) {
            return StrConstant.NULL;
        }
        if (lenFunc.isConstant()) {
            int len = lenFunc.getInt(null);
            if (len < 0) {
                throw SqlException.$(position, "negative substring length is not allowed");
            }
            if (len == 0) {
                return StrConstant.EMPTY;
            }
        }
        return new SubStringFunc(strFunc, startFunc, lenFunc);
    }

    private static class SubStringFunc
    extends StrFunction
    implements TernaryFunction {
        private final Function strFunc;
        private final Function startFunc;
        private final Function lenFunc;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();
        private final boolean isSimplifiable;

        public SubStringFunc(Function strFunc, Function startFunc, Function lenFunc) {
            this.strFunc = strFunc;
            this.startFunc = startFunc;
            this.lenFunc = lenFunc;
            this.isSimplifiable = startFunc.isConstant() && lenFunc.isConstant() && startFunc.getInt(null) + lenFunc.getInt(null) < 1;
        }

        @Override
        public Function getLeft() {
            return this.strFunc;
        }

        @Override
        public Function getCenter() {
            return this.startFunc;
        }

        @Override
        public Function getRight() {
            return this.lenFunc;
        }

        @Override
        public CharSequence getStr(Record rec) {
            return this.getStr0(rec, this.sinkA);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStr0(rec, this.sinkB);
        }

        @Override
        public int getStrLen(Record rec) {
            int strLen = this.strFunc.getStrLen(rec);
            int rawStart = this.startFunc.getInt(rec);
            int len = this.lenFunc.getInt(rec);
            if (strLen == -1 || rawStart == Integer.MIN_VALUE || len == Integer.MIN_VALUE) {
                return -1;
            }
            int start = Math.max(0, rawStart - 1);
            if (len == 0 || start > strLen || rawStart + len < 1) {
                return 0;
            }
            int end = Math.min(strLen, rawStart + len - 1);
            return Math.max(0, end - start);
        }

        @Nullable
        private StringSink getStr0(Record rec, StringSink sink) {
            CharSequence str = this.strFunc.getStr(rec);
            if (str == null || this.isSimplifiable) {
                return null;
            }
            int rawStart = this.startFunc.getInt(rec);
            int len = this.lenFunc.getInt(rec);
            if (rawStart == Integer.MIN_VALUE || len == Integer.MIN_VALUE) {
                return null;
            }
            if (len < 0) {
                throw CairoException.nonCritical().put("negative substring length is not allowed");
            }
            sink.clear();
            int start = Math.max(0, rawStart - 1);
            int end = Math.min(str.length(), rawStart + len - 1);
            if (len == 0 || start >= end) {
                return sink;
            }
            sink.put(str, start, end);
            return sink;
        }
    }
}

