/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public class RightFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "right(SI)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function strFunc = args.getQuick(0);
        Function countFunc = args.getQuick(1);
        if (countFunc.isConstant()) {
            int count = countFunc.getInt(null);
            if (count != Integer.MIN_VALUE) {
                return new RightStrConstCountFunction(strFunc, count);
            }
            return StrConstant.NULL;
        }
        return new RightStrFunction(strFunc, countFunc);
    }

    private static int getPos(int len, int count) {
        return count > -1 ? Math.min(len, Math.max(0, len - count)) : Math.min(len, -count);
    }

    private static class RightStrConstCountFunction
    extends StrFunction
    implements UnaryFunction {
        private final StringSink sink = new StringSink();
        private final StringSink sinkB = new StringSink();
        private final Function strFunc;
        private final int count;

        public RightStrConstCountFunction(Function strFunc, int count) {
            this.strFunc = strFunc;
            this.count = count;
        }

        @Override
        public Function getArg() {
            return this.strFunc;
        }

        @Override
        public CharSequence getStr(Record rec) {
            return this.getStr0(rec, this.sink);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStr0(rec, this.sinkB);
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            CharSequence str = this.strFunc.getStr(rec);
            if (str != null) {
                int len = str.length();
                int pos = this.getPos(len);
                sink.put(str, pos, len);
            }
        }

        @Override
        public int getStrLen(Record rec) {
            int len = this.strFunc.getStrLen(rec);
            int pos = len == -1 ? 0 : this.getPos(len);
            return len - pos;
        }

        private int getPos(int len) {
            return RightFunctionFactory.getPos(len, this.count);
        }

        @Nullable
        private StringSink getStr0(Record rec, StringSink sink) {
            CharSequence str = this.strFunc.getStr(rec);
            if (str != null) {
                int len = str.length();
                int pos = this.getPos(len);
                sink.clear();
                sink.put(str, pos, len);
                return sink;
            }
            return null;
        }
    }

    private static class RightStrFunction
    extends StrFunction
    implements BinaryFunction {
        private final StringSink sink = new StringSink();
        private final StringSink sinkB = new StringSink();
        private final Function strFunc;
        private final Function countFunc;

        public RightStrFunction(Function strFunc, Function countFunc) {
            this.strFunc = strFunc;
            this.countFunc = countFunc;
        }

        @Override
        public Function getLeft() {
            return this.strFunc;
        }

        @Override
        public Function getRight() {
            return this.countFunc;
        }

        @Override
        public CharSequence getStr(Record rec) {
            return this.getStr0(rec, this.sink);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStr0(rec, this.sinkB);
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            CharSequence str = this.strFunc.getStr(rec);
            int count = this.countFunc.getInt(rec);
            if (str != null && count != Integer.MIN_VALUE) {
                int len = str.length();
                int pos = RightFunctionFactory.getPos(len, count);
                sink.put(str, pos, len);
            }
        }

        @Override
        public int getStrLen(Record rec) {
            int count = this.countFunc.getInt(rec);
            if (count != Integer.MIN_VALUE) {
                int len;
                return len - ((len = this.strFunc.getStrLen(rec)) == -1 ? 0 : RightFunctionFactory.getPos(len, count));
            }
            return -1;
        }

        @Nullable
        private StringSink getStr0(Record rec, StringSink sink) {
            CharSequence str = this.strFunc.getStr(rec);
            int count = this.countFunc.getInt(rec);
            if (str != null && count != Integer.MIN_VALUE) {
                int len = str.length();
                int pos = RightFunctionFactory.getPos(len, count);
                sink.clear();
                sink.put(str, pos, len);
                return sink;
            }
            return null;
        }
    }
}

