/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndDoubleCCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_double(i)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int nanRate = args.getQuick(0).getInt(null);
        if (nanRate < 0) {
            throw SqlException.$(argPositions.getQuick(0), "invalid NaN rate");
        }
        return new RndFunction(nanRate);
    }

    private static class RndFunction
    extends DoubleFunction
    implements Function {
        private final int nanRate;
        private Rnd rnd;

        public RndFunction(int nanRate) {
            this.nanRate = nanRate + 1;
        }

        @Override
        public double getDouble(Record rec) {
            if (this.rnd.nextInt() % this.nanRate == 1) {
                return Double.NaN;
            }
            return this.rnd.nextDouble();
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }
    }
}

