/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.regex;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.regex.RegexUtils;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import java.util.regex.Matcher;

public class MatchStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "~(SS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function value = args.getQuick(0);
        Function pattern = args.getQuick(1);
        int patternPosition = argPositions.getQuick(1);
        if (pattern.isConstant()) {
            return new MatchConstPatternFunction(value, RegexUtils.createMatcher(pattern, patternPosition));
        }
        if (pattern.isRuntimeConstant()) {
            return new MatchRuntimeConstPatternFunction(value, pattern, patternPosition);
        }
        throw SqlException.$(patternPosition, "not implemented: dynamic pattern would be very slow to execute");
    }

    private static class MatchRuntimeConstPatternFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Function value;
        private final Function pattern;
        private final int patternPosition;
        private Matcher matcher;

        public MatchRuntimeConstPatternFunction(Function value, Function pattern, int patternPosition) {
            this.value = value;
            this.pattern = pattern;
            this.patternPosition = patternPosition;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence cs = this.getArg().getStr(rec);
            return cs != null && this.matcher.reset(cs).find();
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean isRuntimeConstant() {
            return false;
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            UnaryFunction.super.init(symbolTableSource, executionContext);
            this.pattern.init(symbolTableSource, executionContext);
            this.matcher = RegexUtils.createMatcher(this.pattern, this.patternPosition);
        }
    }

    private static class MatchConstPatternFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Function value;
        private final Matcher matcher;

        public MatchConstPatternFunction(Function value, Matcher matcher) {
            this.value = value;
            this.matcher = matcher;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence cs = this.getArg().getStr(rec);
            return cs != null && this.matcher.reset(cs).find();
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }
    }
}

