/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.Long256Function;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;

public class SumLong256GroupByFunction
extends Long256Function
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public SumLong256GroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        Long256 value = this.arg.getLong256A(record);
        if (!value.equals(Long256Impl.NULL_LONG256)) {
            mapValue.putLong256(this.valueIndex, value);
            mapValue.putLong(this.valueIndex + 1, 1L);
        } else {
            mapValue.putLong256(this.valueIndex, Long256Impl.ZERO_LONG256);
            mapValue.putLong(this.valueIndex + 1, 0L);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        Long256 value = this.arg.getLong256A(record);
        if (!value.equals(Long256Impl.NULL_LONG256)) {
            mapValue.addLong256(this.valueIndex, value);
            mapValue.addLong(this.valueIndex + 1, 1L);
        }
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(13);
        columnTypes.add(6);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong256(this.valueIndex, Long256Impl.NULL_LONG256);
        mapValue.putLong(this.valueIndex + 1, 0L);
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public void getLong256(Record rec, CharSink sink) {
        Long256Impl v = (Long256Impl)this.getLong256A(rec);
        v.toSink(sink);
    }

    @Override
    public Long256 getLong256A(Record rec) {
        Long256Impl res = new Long256Impl();
        if (rec.getLong(this.valueIndex + 1) > 0L) {
            res.copyFrom(rec.getLong256A(this.valueIndex));
            return res;
        }
        return Long256Impl.NULL_LONG256;
    }

    @Override
    public Long256 getLong256B(Record rec) {
        return this.getLong256A(rec);
    }

    @Override
    public boolean isConstant() {
        return false;
    }
}

