/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Chars;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.NotNull;

public class MaxStrGroupByFunction
extends StrFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;
    private int sinkIndex;
    private final ObjList<StringSink> sinks = new ObjList();

    public MaxStrGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public void clear() {
        this.sinks.clear();
        this.sinkIndex = 0;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        CharSequence val = this.arg.getStr(record);
        if (val == null) {
            mapValue.putInt(this.valueIndex, Integer.MIN_VALUE);
        } else {
            StringSink sink = this.nextSink();
            sink.put(val);
            mapValue.putInt(this.valueIndex, this.sinkIndex++);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        CharSequence val = this.arg.getStr(record);
        if (val != null) {
            int index = mapValue.getInt(this.valueIndex);
            if (index == Integer.MIN_VALUE) {
                StringSink sink = this.nextSink();
                sink.put(val);
                mapValue.putInt(this.valueIndex, this.sinkIndex++);
                return;
            }
            StringSink maxSink = this.sinks.getQuick(index);
            if (Chars.compare(maxSink, val) < 0) {
                maxSink.clear();
                maxSink.put(val);
            }
        }
    }

    private StringSink nextSink() {
        StringSink sink;
        if (this.sinks.size() <= this.sinkIndex) {
            sink = new StringSink();
            this.sinks.extendAndSet(this.sinkIndex, sink);
        } else {
            sink = this.sinks.getQuick(this.sinkIndex);
        }
        sink.clear();
        return sink;
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(5);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putInt(this.valueIndex, Integer.MIN_VALUE);
    }

    @Override
    public CharSequence getStr(Record rec) {
        int index = rec.getInt(this.valueIndex);
        return index == Integer.MIN_VALUE ? null : (CharSequence)this.sinks.getQuick(index);
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.getStr(rec);
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isReadThreadSafe() {
        return false;
    }

    @Override
    public void toTop() {
        UnaryFunction.super.toTop();
        this.sinkIndex = 0;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("MaxStr(").put(this.arg).put(')');
    }
}

