/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DateFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;

public class MaxDateGroupByFunction
extends DateFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public MaxDateGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putLong(this.valueIndex, this.arg.getLong(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        long max = mapValue.getDate(this.valueIndex);
        long next = this.arg.getDate(record);
        if (next > max) {
            mapValue.putDate(this.valueIndex, next);
        }
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(7);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putDate(this.valueIndex, Long.MIN_VALUE);
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public long getDate(Record rec) {
        return rec.getDate(this.valueIndex);
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("MaxDate(").put(this.arg).put(')');
    }
}

