/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.CharFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;

public class MaxCharGroupByFunction
extends CharFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public MaxCharGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putChar(this.valueIndex, this.arg.getChar(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        char max = mapValue.getChar(this.valueIndex);
        char next = this.arg.getChar(record);
        if (next > max) {
            mapValue.putChar(this.valueIndex, next);
        }
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(4);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putChar(this.valueIndex, '\u0000');
    }

    @Override
    public char getChar(Record rec) {
        return rec.getChar(this.valueIndex);
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("MaxChar(").put(this.arg).put(')');
    }
}

