/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.InterpolationUtil;
import io.questdb.std.BinarySequence;
import io.questdb.std.Long256;
import io.questdb.std.str.CharSink;

public class InterpolationGroupByFunction
implements GroupByFunction {
    private final GroupByFunction wrappedFunction;
    private boolean interpolating;
    private long startTime;
    private long endTime;
    private long interval;
    private long current;
    private Record target;

    private InterpolationGroupByFunction(GroupByFunction wrappedFunction) {
        this.wrappedFunction = wrappedFunction;
    }

    public static InterpolationGroupByFunction newInstance(GroupByFunction wrappedFunction) {
        return new InterpolationGroupByFunction(wrappedFunction);
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        this.wrappedFunction.computeFirst(mapValue, record);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        this.wrappedFunction.computeNext(mapValue, record);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.wrappedFunction.pushValueTypes(columnTypes);
    }

    @Override
    public void setNull(MapValue mapValue) {
        this.wrappedFunction.setNull(mapValue);
    }

    @Override
    public int getArrayLength() {
        return this.wrappedFunction.getArrayLength();
    }

    @Override
    public BinarySequence getBin(Record rec) {
        return this.wrappedFunction.getBin(rec);
    }

    @Override
    public long getBinLen(Record rec) {
        return this.wrappedFunction.getBinLen(rec);
    }

    @Override
    public boolean getBool(Record rec) {
        return this.wrappedFunction.getBool(rec);
    }

    @Override
    public byte getByte(Record rec) {
        byte value = this.wrappedFunction.getByte(rec);
        if (this.interpolating) {
            return (byte)InterpolationUtil.interpolate(this.startTime + this.current++ * this.interval, this.startTime, value, this.endTime, this.wrappedFunction.getByte(this.target));
        }
        return value;
    }

    @Override
    public char getChar(Record rec) {
        char value = this.wrappedFunction.getChar(rec);
        if (this.interpolating) {
            return (char)InterpolationUtil.interpolate(this.startTime + this.current++ * this.interval, this.startTime, value, this.endTime, this.wrappedFunction.getChar(this.target));
        }
        return value;
    }

    @Override
    public long getDate(Record rec) {
        return this.wrappedFunction.getDate(rec);
    }

    @Override
    public double getDouble(Record rec) {
        double value = this.wrappedFunction.getDouble(rec);
        if (this.interpolating) {
            return InterpolationUtil.interpolate(this.startTime + this.current++ * this.interval, this.startTime, value, this.endTime, this.wrappedFunction.getDouble(this.target));
        }
        return value;
    }

    @Override
    public float getFloat(Record rec) {
        float value = this.wrappedFunction.getFloat(rec);
        if (this.interpolating) {
            return (float)InterpolationUtil.interpolate(this.startTime + this.current++ * this.interval, this.startTime, value, this.endTime, this.wrappedFunction.getFloat(this.target));
        }
        return value;
    }

    @Override
    public int getInt(Record rec) {
        int value = this.wrappedFunction.getInt(rec);
        if (this.interpolating) {
            return (int)InterpolationUtil.interpolate(this.startTime + this.current++ * this.interval, this.startTime, value, this.endTime, this.wrappedFunction.getInt(this.target));
        }
        return value;
    }

    @Override
    public long getLong(Record rec) {
        long value = this.wrappedFunction.getLong(rec);
        if (this.interpolating) {
            return (long)InterpolationUtil.interpolate(this.startTime + this.current++ * this.interval, this.startTime, value, this.endTime, this.wrappedFunction.getLong(this.target));
        }
        return value;
    }

    @Override
    public void getLong256(Record rec, CharSink sink) {
        this.wrappedFunction.getLong256(rec, sink);
    }

    @Override
    public Long256 getLong256A(Record rec) {
        return this.wrappedFunction.getLong256A(rec);
    }

    @Override
    public Long256 getLong256B(Record rec) {
        return this.wrappedFunction.getLong256B(rec);
    }

    @Override
    public long getLong128Hi(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong128Lo(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RecordCursorFactory getRecordCursorFactory() {
        return this.wrappedFunction.getRecordCursorFactory();
    }

    @Override
    public Record getRecord(Record rec) {
        return this.wrappedFunction.getRecord(rec);
    }

    @Override
    public short getShort(Record rec) {
        short value = this.wrappedFunction.getShort(rec);
        if (this.interpolating) {
            return (short)InterpolationUtil.interpolate(this.startTime + this.current++ * this.interval, this.startTime, value, this.endTime, this.wrappedFunction.getShort(this.target));
        }
        return value;
    }

    @Override
    public CharSequence getStr(Record rec) {
        return this.wrappedFunction.getStr(rec);
    }

    @Override
    public CharSequence getStr(Record rec, int arrayIndex) {
        return this.wrappedFunction.getStr(rec, arrayIndex);
    }

    @Override
    public void getStr(Record rec, CharSink sink) {
        this.wrappedFunction.getStr(rec, sink);
    }

    @Override
    public void getStr(Record rec, CharSink sink, int arrayIndex) {
        this.wrappedFunction.getStr(rec, sink, arrayIndex);
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.wrappedFunction.getStrB(rec);
    }

    @Override
    public CharSequence getStrB(Record rec, int arrayIndex) {
        return this.wrappedFunction.getStrB(rec, arrayIndex);
    }

    @Override
    public int getStrLen(Record rec) {
        return this.wrappedFunction.getStrLen(rec);
    }

    @Override
    public int getStrLen(Record rec, int arrayIndex) {
        return this.wrappedFunction.getStrLen(rec, arrayIndex);
    }

    @Override
    public CharSequence getSymbol(Record rec) {
        return this.wrappedFunction.getSymbol(rec);
    }

    @Override
    public CharSequence getSymbolB(Record rec) {
        return this.wrappedFunction.getSymbolB(rec);
    }

    @Override
    public long getTimestamp(Record rec) {
        return this.wrappedFunction.getTimestamp(rec);
    }

    @Override
    public byte getGeoByte(Record rec) {
        return this.wrappedFunction.getGeoByte(rec);
    }

    @Override
    public short getGeoShort(Record rec) {
        return this.wrappedFunction.getGeoShort(rec);
    }

    @Override
    public int getGeoInt(Record rec) {
        return this.wrappedFunction.getGeoInt(rec);
    }

    @Override
    public long getGeoLong(Record rec) {
        return this.wrappedFunction.getGeoLong(rec);
    }

    @Override
    public int getType() {
        return this.wrappedFunction.getType();
    }

    public void setTarget(Record target) {
        this.target = target;
    }

    public void startInterpolating(long startTime, long currentTime, long endTime) {
        this.interpolating = true;
        this.startTime = startTime;
        this.endTime = endTime;
        this.interval = currentTime - startTime;
        this.current = 1L;
    }

    public void stopInterpolating() {
        this.interpolating = false;
    }
}

