/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GeoByteFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;

class FirstGeoHashGroupByFunctionInt
extends GeoByteFunction
implements GroupByFunction,
UnaryFunction {
    protected final Function function;
    protected int valueIndex;

    public FirstGeoHashGroupByFunctionInt(int type, Function function) {
        super(type);
        this.function = function;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putInt(this.valueIndex, this.function.getGeoInt(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
    }

    @Override
    public Function getArg() {
        return this.function;
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(5);
    }

    @Override
    public void setInt(MapValue mapValue, int value) {
        mapValue.putInt(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        this.setInt(mapValue, -1);
    }

    @Override
    public byte getGeoByte(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getGeoShort(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGeoInt(Record rec) {
        return rec.getGeoInt(this.valueIndex);
    }

    @Override
    public long getGeoLong(Record rec) {
        throw new UnsupportedOperationException();
    }
}

