/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.ObjList;

public class CountStringGroupByFunction
extends LongFunction
implements UnaryFunction,
GroupByFunction {
    private final Function arg;
    private final ObjList<CharSequenceHashSet> sets = new ObjList();
    private int valueIndex;
    private int setIndex = 0;

    public CountStringGroupByFunction(Function arg) {
        this.arg = arg;
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public void clear() {
        this.sets.clear();
        this.setIndex = 0;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        CharSequenceHashSet set;
        if (this.sets.size() <= this.setIndex) {
            set = new CharSequenceHashSet();
            this.sets.extendAndSet(this.setIndex, set);
        } else {
            set = this.sets.getQuick(this.setIndex);
        }
        set.clear();
        CharSequence val = this.arg.getStr(record);
        if (val != null) {
            set.add(Chars.toString(val));
            mapValue.putLong(this.valueIndex, 1L);
        } else {
            mapValue.putLong(this.valueIndex, 0L);
        }
        mapValue.putInt(this.valueIndex + 1, this.setIndex++);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        CharSequenceHashSet set = this.sets.getQuick(mapValue.getInt(this.valueIndex + 1));
        CharSequence val = this.arg.getStr(record);
        if (val != null) {
            int index = set.keyIndex(val);
            if (index < 0) {
                return;
            }
            set.addAt(index, Chars.toString(val));
            mapValue.addLong(this.valueIndex, 1L);
        }
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
        columnTypes.add(5);
    }

    @Override
    public void setEmpty(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, 0L);
    }

    @Override
    public void setLong(MapValue mapValue, long value) {
        mapValue.putLong(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
    }

    @Override
    public long getLong(Record rec) {
        return rec.getLong(this.valueIndex);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isReadThreadSafe() {
        return false;
    }

    @Override
    public void toTop() {
        UnaryFunction.super.toTop();
        this.setIndex = 0;
    }
}

