/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.geohash;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.AbstractGeoHashFunction;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.std.IntList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class GeoHashFromCoordinatesFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "make_geohash(DDi)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function bitsArg = args.get(2);
        int bits = bitsArg.getInt(null);
        if (bits < 1 || bits > ColumnType.GEO_HASH_MAX_BITS_LENGTH) {
            throw SqlException.$(argPositions.getQuick(2), "precision must be in [1..60] range");
        }
        int type = ColumnType.getGeoHashTypeWithBits(bits);
        Function lonArg = args.get(0);
        Function latArg = args.get(1);
        boolean isLonConst = lonArg.isConstant();
        boolean isLatConst = latArg.isConstant();
        if (isLonConst && isLatConst) {
            double lon = lonArg.getDouble(null);
            if (lon < -180.0 || lon > 180.0) {
                throw SqlException.$(argPositions.getQuick(0), "longitude must be in [-180.0..180.0] range");
            }
            double lat = latArg.getDouble(null);
            if (lat < -90.0 || lat > 90.0) {
                throw SqlException.$(argPositions.getQuick(1), "latitude must be in [-90.0..90.0] range");
            }
            return Constants.getGeoHashConstantWithType(GeoHashes.fromCoordinatesDegUnsafe(lat, lon, bits), type);
        }
        return new FromCoordinatesFixedBitsFunction(lonArg, latArg, bits);
    }

    private static class FromCoordinatesFixedBitsFunction
    extends AbstractGeoHashFunction
    implements BinaryFunction {
        private final Function lon;
        private final Function lat;
        private final int bits;

        public FromCoordinatesFixedBitsFunction(Function lon, Function lat, int bits) {
            super(ColumnType.getGeoHashTypeWithBits(bits));
            this.lon = lon;
            this.lat = lat;
            this.bits = bits;
        }

        private long getLongValue(Record rec) {
            try {
                double lon = this.lon.getDouble(rec);
                double lat = this.lat.getDouble(rec);
                return GeoHashes.fromCoordinatesDeg(lat, lon, this.bits);
            }
            catch (NumericException e) {
                return -1L;
            }
        }

        @Override
        public byte getGeoByte(Record rec) {
            return (byte)this.getLongValue(rec);
        }

        @Override
        public short getGeoShort(Record rec) {
            return (short)this.getLongValue(rec);
        }

        @Override
        public int getGeoInt(Record rec) {
            return (int)this.getLongValue(rec);
        }

        @Override
        public long getGeoLong(Record rec) {
            return this.getLongValue(rec);
        }

        @Override
        public Function getLeft() {
            return this.lat;
        }

        @Override
        public Function getRight() {
            return this.lon;
        }
    }
}

