/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class EqCharCharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(AA)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function chrFunc1 = args.getQuick(0);
        Function chrFunc2 = args.getQuick(1);
        return new Func(chrFunc1, chrFunc2);
    }

    private static class Func
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function chrFunc1;
        private final Function chrFunc2;

        public Func(Function chrFunc1, Function chrFunc2) {
            this.chrFunc1 = chrFunc1;
            this.chrFunc2 = chrFunc2;
        }

        @Override
        public Function getLeft() {
            return this.chrFunc1;
        }

        @Override
        public Function getRight() {
            return this.chrFunc2;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.chrFunc1.getChar(rec) == this.chrFunc2.getChar(rec));
        }
    }
}

