/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class TimestampShuffleFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "timestamp_shuffle(nn)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        long start = args.getQuick(0).getTimestamp(null);
        long end = args.getQuick(1).getTimestamp(null);
        if (start == Long.MIN_VALUE || end == Long.MIN_VALUE) {
            return TimestampConstant.NULL;
        }
        return new TimestampShuffleFunction(start, end);
    }

    private static class TimestampShuffleFunction
    extends TimestampFunction {
        private final long start;
        private final long end;
        private Rnd rnd;

        public TimestampShuffleFunction(long start, long end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public void close() {
        }

        @Override
        public long getTimestamp(Record rec) {
            return this.start + this.rnd.nextPositiveLong() % (this.end - this.start);
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public void toTop() {
            this.rnd.reset();
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }
    }
}

