/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.datetime.microtime.Timestamps;

final class TimestampFloorFunctions {
    private TimestampFloorFunctions() {
    }

    static class TimestampFloorMillenniumFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorMillenniumFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMillennium(timestamp);
        }
    }

    static class TimestampFloorCenturyFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorCenturyFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorCentury(timestamp);
        }
    }

    static class TimestampFloorDecadeFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorDecadeFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorDecade(timestamp);
        }
    }

    static class TimestampFloorQuarterFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorQuarterFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorQuarter(timestamp);
        }
    }

    static class TimestampFloorDayOfWeekFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorDayOfWeekFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorDOW(timestamp);
        }
    }

    static class TimestampFloorMSFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorMSFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMS(timestamp);
        }
    }

    static class TimestampFloorSSFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorSSFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorSS(timestamp);
        }
    }

    static class TimestampFloorMIFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorMIFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMI(timestamp);
        }
    }

    static class TimestampFloorHHFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorHHFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorHH(timestamp);
        }
    }

    static class TimestampFloorYYYYFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorYYYYFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorYYYY(timestamp);
        }
    }

    static class TimestampFloorMMFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorMMFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMM(timestamp);
        }
    }

    static class TimestampFloorDDFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorDDFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorDD(timestamp);
        }
    }

    static abstract class AbstractTimestampFloorFunction
    extends TimestampFunction
    implements UnaryFunction {
        private final Function arg;

        public AbstractTimestampFloorFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public final long getTimestamp(Record rec) {
            long micros = this.arg.getTimestamp(rec);
            return micros == Long.MIN_VALUE ? Long.MIN_VALUE : this.floor(micros);
        }

        protected abstract long floor(long var1);
    }
}

