/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.Timestamps;

public class TimestampDiffFunctionFactory
implements FunctionFactory {
    private static final ObjList<LongDiffFunction> diffFunctions = new ObjList();
    private static final int diffFunctionsMax;

    @Override
    public String getSignature() {
        return "datediff(ANN)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function perionFunction = args.getQuick(0);
        if (perionFunction.isConstant()) {
            LongDiffFunction func;
            Function start = args.getQuick(1);
            Function end = args.getQuick(2);
            char period = perionFunction.getChar(null);
            if (period < diffFunctionsMax && (func = diffFunctions.getQuick(period)) != null) {
                if (start.isConstant() && start.getTimestamp(null) != Long.MIN_VALUE) {
                    return new DiffVarConstFunction(args.getQuick(2), start.getLong(null), func);
                }
                if (end.isConstant() && end.getTimestamp(null) != Long.MIN_VALUE) {
                    return new DiffVarConstFunction(args.getQuick(1), end.getLong(null), func);
                }
                return new DiffVarVarFunction(args.getQuick(1), args.getQuick(2), func);
            }
            return TimestampConstant.NULL;
        }
        return new DateDiffFunc(args.getQuick(0), args.getQuick(1), args.getQuick(2));
    }

    static {
        diffFunctions.extendAndSet(115, Timestamps::getSecondsBetween);
        diffFunctions.extendAndSet(109, Timestamps::getMinutesBetween);
        diffFunctions.extendAndSet(104, Timestamps::getHoursBetween);
        diffFunctions.extendAndSet(100, Timestamps::getDaysBetween);
        diffFunctions.extendAndSet(119, Timestamps::getWeeksBetween);
        diffFunctions.extendAndSet(77, Timestamps::getMonthsBetween);
        diffFunctions.extendAndSet(121, Timestamps::getYearsBetween);
        diffFunctionsMax = diffFunctions.size();
    }

    private static class DateDiffFunc
    extends LongFunction
    implements TernaryFunction {
        final Function left;
        final Function center;
        final Function right;

        public DateDiffFunc(Function left, Function center, Function right) {
            this.left = left;
            this.center = center;
            this.right = right;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getCenter() {
            return this.center;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public long getLong(Record rec) {
            char l = this.left.getChar(rec);
            long c = this.center.getTimestamp(rec);
            long r = this.right.getTimestamp(rec);
            if (c == Long.MIN_VALUE || r == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return Timestamps.getPeriodBetween(l, c, r);
        }
    }

    private static class DiffVarConstFunction
    extends LongFunction
    implements UnaryFunction {
        private final Function arg;
        private final long constantTime;
        private final LongDiffFunction func;

        public DiffVarConstFunction(Function left, long right, LongDiffFunction func) {
            this.arg = left;
            this.constantTime = right;
            this.func = func;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getLong(Record rec) {
            long l = this.arg.getTimestamp(rec);
            if (l == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return this.func.diff(l, this.constantTime);
        }
    }

    private static class DiffVarVarFunction
    extends LongFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;
        private final LongDiffFunction func;

        public DiffVarVarFunction(Function left, Function right, LongDiffFunction func) {
            this.left = left;
            this.right = right;
            this.func = func;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public long getLong(Record rec) {
            long l = this.left.getTimestamp(rec);
            long r = this.right.getTimestamp(rec);
            if (l == Long.MIN_VALUE || r == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return this.func.diff(l, r);
        }
    }

    @FunctionalInterface
    private static interface LongDiffFunction {
        public long diff(long var1, long var3);
    }
}

