/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.Chars;

public class StrConstant
extends StrFunction
implements ConstantFunction {
    public static final StrConstant NULL = new StrConstant(null);
    public static final StrConstant EMPTY = new StrConstant("");
    private final String value;
    private final int length;

    public StrConstant(CharSequence value) {
        if (value == null) {
            this.value = null;
            this.length = -1;
        } else {
            this.value = Chars.startsWith(value, '\'') ? Chars.toString(value, 1, value.length() - 1, value.charAt(0)) : Chars.toString(value);
            this.length = this.value.length();
        }
    }

    public static StrConstant newInstance(CharSequence value) {
        return value != null ? new StrConstant(value) : NULL;
    }

    @Override
    public CharSequence getStr(Record rec) {
        return this.value;
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.value;
    }

    @Override
    public int getStrLen(Record rec) {
        return this.length;
    }
}

