/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class TimestampColumn
extends TimestampFunction
implements ScalarFunction {
    private static final ObjList<TimestampColumn> COLUMNS = new ObjList(32);
    private final int columnIndex;

    public TimestampColumn(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public static TimestampColumn newInstance(int columnIndex) {
        if (columnIndex < 32) {
            return COLUMNS.getQuick(columnIndex);
        }
        return new TimestampColumn(columnIndex);
    }

    @Override
    public long getTimestamp(Record rec) {
        return rec.getTimestamp(this.columnIndex);
    }

    @Override
    public boolean isReadThreadSafe() {
        return true;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("TimestampColumn(").put(this.columnIndex).put(')');
    }

    static {
        COLUMNS.setPos(32);
        for (int i = 0; i < 32; ++i) {
            COLUMNS.setQuick(i, new TimestampColumn(i));
        }
    }
}

