/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.engine.functions.ShortFunction;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class ShortColumn
extends ShortFunction
implements ScalarFunction {
    private static final ObjList<ShortColumn> COLUMNS = new ObjList(32);
    private final int columnIndex;

    public ShortColumn(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public static ShortColumn newInstance(int columnIndex) {
        if (columnIndex < 32) {
            return COLUMNS.getQuick(columnIndex);
        }
        return new ShortColumn(columnIndex);
    }

    @Override
    public short getShort(Record rec) {
        return rec.getShort(this.columnIndex);
    }

    @Override
    public boolean isReadThreadSafe() {
        return true;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("ShortColumn(").put(this.columnIndex).put(')');
    }

    static {
        COLUMNS.setPos(32);
        for (int i = 0; i < 32; ++i) {
            COLUMNS.setQuick(i, new ShortColumn(i));
        }
    }
}

