/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.std.ObjList;
import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;

public class IntColumn
extends IntFunction
implements ScalarFunction,
Sinkable {
    private static final ObjList<IntColumn> COLUMNS = new ObjList(32);
    private final int columnIndex;

    public IntColumn(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public static IntColumn newInstance(int columnIndex) {
        if (columnIndex < 32) {
            return COLUMNS.getQuick(columnIndex);
        }
        return new IntColumn(columnIndex);
    }

    @Override
    public int getInt(Record rec) {
        return rec.getInt(this.columnIndex);
    }

    @Override
    public boolean isReadThreadSafe() {
        return true;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("IntColumn(").put(this.columnIndex).put(')');
    }

    static {
        COLUMNS.setPos(32);
        for (int i = 0; i < 32; ++i) {
            COLUMNS.setQuick(i, new IntColumn(i));
        }
    }
}

