/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GeoShortFunction;
import io.questdb.std.str.CharSink;

public class GeoShortColumn
extends GeoShortFunction {
    private static final GeoShortColumn[] COLUMNS;
    private final int columnIndex;

    public GeoShortColumn(int columnIndex, int columnType) {
        super(columnType);
        this.columnIndex = columnIndex;
    }

    public static GeoShortColumn newInstance(int columnIndex, int columnType) {
        assert (ColumnType.getGeoHashBits(columnType) >= 8 && ColumnType.getGeoHashBits(columnType) <= 15);
        int bits = 8;
        if (columnIndex < 32) {
            return COLUMNS[columnIndex * 8 + ColumnType.getGeoHashBits(columnType) - 8];
        }
        return new GeoShortColumn(columnIndex, columnType);
    }

    @Override
    public short getGeoShort(Record rec) {
        return rec.getGeoShort(this.columnIndex);
    }

    @Override
    public boolean isReadThreadSafe() {
        return true;
    }

    int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("GeoShortColumn(").put(this.columnIndex).put(')');
    }

    static {
        int bits = 8;
        COLUMNS = new GeoShortColumn[32 * bits];
        for (int col = 0; col < 32; ++col) {
            for (int bit = 8; bit <= 15; ++bit) {
                GeoShortColumn.COLUMNS[col * bits + bit - 8] = new GeoShortColumn(col, ColumnType.getGeoHashTypeWithBits(bit));
            }
        }
    }
}

