/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GeoLongFunction;
import io.questdb.std.str.CharSink;

public class GeoLongColumn
extends GeoLongFunction {
    private static final GeoLongColumn[] COLUMNS;
    private final int columnIndex;

    public GeoLongColumn(int columnIndex, int columnType) {
        super(columnType);
        this.columnIndex = columnIndex;
    }

    public static GeoLongColumn newInstance(int columnIndex, int columnType) {
        assert (ColumnType.getGeoHashBits(columnType) >= 32 && ColumnType.getGeoHashBits(columnType) <= ColumnType.GEOLONG_MAX_BITS);
        int bits = ColumnType.GEOLONG_MAX_BITS - 32 + 1;
        if (columnIndex < 32) {
            return COLUMNS[columnIndex * bits + ColumnType.getGeoHashBits(columnType) - 32];
        }
        return new GeoLongColumn(columnIndex, columnType);
    }

    @Override
    public long getGeoLong(Record rec) {
        return rec.getGeoLong(this.columnIndex);
    }

    @Override
    public boolean isReadThreadSafe() {
        return true;
    }

    int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("GeoLongColumn(").put(this.columnIndex).put(')');
    }

    static {
        int bits = ColumnType.GEOLONG_MAX_BITS - 32 + 1;
        COLUMNS = new GeoLongColumn[32 * bits];
        for (int col = 0; col < 32; ++col) {
            for (int bit = 32; bit <= ColumnType.GEOLONG_MAX_BITS; ++bit) {
                GeoLongColumn.COLUMNS[col * bits + bit - 32] = new GeoLongColumn(col, ColumnType.getGeoHashTypeWithBits(bit));
            }
        }
    }
}

