/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class DoubleColumn
extends DoubleFunction
implements ScalarFunction {
    private static final ObjList<DoubleColumn> COLUMNS = new ObjList(32);
    private final int columnIndex;

    public DoubleColumn(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public static DoubleColumn newInstance(int columnIndex) {
        if (columnIndex < 32) {
            return COLUMNS.getQuick(columnIndex);
        }
        return new DoubleColumn(columnIndex);
    }

    @Override
    public double getDouble(Record rec) {
        return rec.getDouble(this.columnIndex);
    }

    @Override
    public boolean isReadThreadSafe() {
        return true;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("DoubleColumn(").put(this.columnIndex).put(')');
    }

    static {
        COLUMNS.setPos(32);
        for (int i = 0; i < 32; ++i) {
            COLUMNS.setQuick(i, new DoubleColumn(i));
        }
    }
}

