/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.engine.functions.ByteFunction;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class ByteColumn
extends ByteFunction
implements ScalarFunction {
    private static final ObjList<ByteColumn> COLUMNS = new ObjList(32);
    private final int columnIndex;

    public ByteColumn(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public static ByteColumn newInstance(int columnIndex) {
        if (columnIndex < 32) {
            return COLUMNS.getQuick(columnIndex);
        }
        return new ByteColumn(columnIndex);
    }

    @Override
    public byte getByte(Record rec) {
        return rec.getByte(this.columnIndex);
    }

    @Override
    public boolean isReadThreadSafe() {
        return true;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("ByteColumn(").put(this.columnIndex).put(')');
    }

    static {
        COLUMNS.setPos(32);
        for (int i = 0; i < 32; ++i) {
            COLUMNS.setQuick(i, new ByteColumn(i));
        }
    }
}

