/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.IntList;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.ObjList;

public class TypeOfFunctionFactory
implements FunctionFactory {
    static final Function NULL = new StrConstant("NULL");
    static final IntObjHashMap<Function> TYPE_NAMES = new IntObjHashMap();

    @Override
    public String getSignature() {
        return "typeOf(V)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (args != null && args.size() == 1) {
            Function arg = args.getQuick(0);
            int argType = arg.getType();
            return ColumnType.isNull(argType) ? NULL : TYPE_NAMES.get(arg.getType());
        }
        throw SqlException.$(position, "exactly one argument expected");
    }

    static {
        TYPE_NAMES.put(1, new StrConstant(ColumnType.nameOf(1)));
        TYPE_NAMES.put(2, new StrConstant(ColumnType.nameOf(2)));
        TYPE_NAMES.put(3, new StrConstant(ColumnType.nameOf(3)));
        TYPE_NAMES.put(4, new StrConstant(ColumnType.nameOf(4)));
        TYPE_NAMES.put(5, new StrConstant(ColumnType.nameOf(5)));
        TYPE_NAMES.put(6, new StrConstant(ColumnType.nameOf(6)));
        TYPE_NAMES.put(7, new StrConstant(ColumnType.nameOf(7)));
        TYPE_NAMES.put(8, new StrConstant(ColumnType.nameOf(8)));
        TYPE_NAMES.put(9, new StrConstant(ColumnType.nameOf(9)));
        TYPE_NAMES.put(10, new StrConstant(ColumnType.nameOf(10)));
        TYPE_NAMES.put(11, new StrConstant(ColumnType.nameOf(11)));
        TYPE_NAMES.put(12, new StrConstant(ColumnType.nameOf(12)));
        TYPE_NAMES.put(13, new StrConstant(ColumnType.nameOf(13)));
        TYPE_NAMES.put(18, new StrConstant(ColumnType.nameOf(18)));
        TYPE_NAMES.put(19, new StrConstant(ColumnType.nameOf(19)));
        TYPE_NAMES.put(20, new StrConstant(ColumnType.nameOf(20)));
        TYPE_NAMES.put(21, new StrConstant(ColumnType.nameOf(21)));
        TYPE_NAMES.put(14, new StrConstant("null(GEOBYTE)"));
        TYPE_NAMES.put(15, new StrConstant("null(GEOSHORT)"));
        TYPE_NAMES.put(16, new StrConstant("null(GEOINT)"));
        TYPE_NAMES.put(17, new StrConstant("null(GEOLONG)"));
        for (int b = 1; b <= ColumnType.GEO_HASH_MAX_BITS_LENGTH; ++b) {
            int type = ColumnType.getGeoHashTypeWithBits(b);
            TYPE_NAMES.put(type, new StrConstant(ColumnType.nameOf(type)));
        }
    }
}

