/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.griffin.engine.functions.GenericRecordCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.Constants;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class PrefixedPgGetKeywordsFunctionFactory
implements FunctionFactory {
    private static final RecordMetadata METADATA;

    @Override
    public String getSignature() {
        return "pg_catalog.pg_get_keywords()";
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new GenericRecordCursorFactory(METADATA, new KeywordsCatalogueCursor(), false)){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("word", 1L, 11));
        metadata.add(new TableColumnMetadata("catcode", 2L, 11));
        metadata.add(new TableColumnMetadata("catdesc", 3L, 11));
        METADATA = metadata;
    }

    private static class KeywordsCatalogueCursor
    implements NoRandomAccessRecordCursor {
        private static final int rowCount = Constants.KEYWORDS.length;
        private final KeywordCatalogueRecord record = new KeywordCatalogueRecord();
        private int row = -1;

        private KeywordsCatalogueCursor() {
        }

        @Override
        public void close() {
            this.row = -1;
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            return ++this.row < rowCount;
        }

        @Override
        public void toTop() {
            this.row = -1;
        }

        @Override
        public long size() {
            return rowCount;
        }

        class KeywordCatalogueRecord
        implements Record {
            KeywordCatalogueRecord() {
            }

            @Override
            public CharSequence getStr(int col) {
                if (col == 0) {
                    return Constants.KEYWORDS[KeywordsCatalogueCursor.this.row];
                }
                return null;
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStr(col);
            }

            @Override
            public int getStrLen(int col) {
                if (col == 0) {
                    return this.getStr(col).length();
                }
                return -1;
            }
        }
    }
}

