/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GeoByteFunction;
import io.questdb.griffin.engine.functions.GeoIntFunction;
import io.questdb.griffin.engine.functions.GeoLongFunction;
import io.questdb.griffin.engine.functions.GeoShortFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastLongToGeoHashFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Lg)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int targetType = args.getQuick(1).getType();
        switch (ColumnType.tagOf(targetType)) {
            case 14: {
                return new CastGeoByteFunc(targetType, args.getQuick(0));
            }
            case 15: {
                return new CastGeoShortFunc(targetType, args.getQuick(0));
            }
            case 16: {
                return new CastGeoIntFunc(targetType, args.getQuick(0));
            }
        }
        return new CastGeoLongFunc(targetType, args.getQuick(0));
    }

    private static class CastGeoLongFunc
    extends GeoLongFunction
    implements UnaryFunction {
        private final Function value;

        public CastGeoLongFunc(int targetType, Function value) {
            super(targetType);
            this.value = value;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public long getGeoLong(Record rec) {
            long value = this.value.getLong(rec);
            return value != Long.MIN_VALUE ? value : -1L;
        }
    }

    private static class CastGeoShortFunc
    extends GeoShortFunction
    implements UnaryFunction {
        private final Function value;

        public CastGeoShortFunc(int targetType, Function value) {
            super(targetType);
            this.value = value;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public short getGeoShort(Record rec) {
            long value = this.value.getLong(rec);
            return value != Long.MIN_VALUE ? (short)value : (short)-1;
        }
    }

    private static class CastGeoIntFunc
    extends GeoIntFunction
    implements UnaryFunction {
        private final Function value;

        public CastGeoIntFunc(int targetType, Function value) {
            super(targetType);
            this.value = value;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public int getGeoInt(Record rec) {
            long value = this.value.getLong(rec);
            return value != Long.MIN_VALUE ? (int)value : -1;
        }
    }

    private static class CastGeoByteFunc
    extends GeoByteFunction
    implements UnaryFunction {
        private final Function value;

        public CastGeoByteFunc(int targetType, Function value) {
            super(targetType);
            this.value = value;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public byte getGeoByte(Record rec) {
            long value = this.value.getLong(rec);
            return value != Long.MIN_VALUE ? (byte)value : (byte)-1;
        }
    }
}

