/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GeoByteFunction;
import io.questdb.griffin.engine.functions.GeoIntFunction;
import io.questdb.griffin.engine.functions.GeoLongFunction;
import io.questdb.griffin.engine.functions.GeoShortFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.NotNull;

public class CastGeoHashToGeoHashFunctionFactory
implements FunctionFactory {
    @NotNull
    public static Function getGeoByteToStrCastFunction(Function value, int srcBitsPrecision) {
        if (srcBitsPrecision % 5 == 0) {
            return new CastGeoByteToStrCharsFunc(value, srcBitsPrecision / 5);
        }
        return new CastGeoByteToStrBitsFunc(value, srcBitsPrecision);
    }

    @NotNull
    public static Function getGeoIntToStrCastFunction(Function value, int srcBitsPrecision) {
        if (srcBitsPrecision % 5 == 0) {
            return new CastGeoIntToStrCharsFunc(value, srcBitsPrecision / 5);
        }
        return new CastGeoIntToStrBitsFunc(value, srcBitsPrecision);
    }

    @NotNull
    public static Function getGeoLongToStrCastFunction(Function value, int srcBitsPrecision) {
        if (srcBitsPrecision % 5 == 0) {
            return new CastGeoLongToStrCharsFunc(value, srcBitsPrecision / 5);
        }
        return new CastGeoLongToStrBitsFunc(value, srcBitsPrecision);
    }

    @NotNull
    public static Function getGeoShortToStrCastFunction(Function value, int srcBitsPrecision) {
        if (srcBitsPrecision % 5 == 0) {
            return new CastGeoShortToStrCharsFunc(value, srcBitsPrecision / 5);
        }
        return new CastGeoShortToStrBitsFunc(value, srcBitsPrecision);
    }

    public static Function newInstance(int position, Function value, int toType, int fromType) throws SqlException {
        int toBits;
        int fromBits = ColumnType.getGeoHashBits(fromType);
        int shift = fromBits - (toBits = ColumnType.getGeoHashBits(toType));
        if (shift > 0) {
            if (value.isConstant()) {
                long val = GeoHashes.getGeoLong(fromType, value, null);
                return Constants.getGeoHashConstantWithType(val >> shift, toType);
            }
            Function result = CastGeoHashToGeoHashFunctionFactory.getCastGeoHashToGeoHashFunction(value, toType, fromType, shift);
            if (result != null) {
                return result;
            }
        } else if (shift == 0) {
            return value;
        }
        if (value.isConstant() && GeoHashes.getGeoLong(value.getType(), value, null) == -1L) {
            return Constants.getNullConstant(toType);
        }
        switch (ColumnType.tagOf(toType)) {
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                throw SqlException.position(position).put("CAST cannot decrease precision from GEOHASH(").put(fromBits).put("b) to GEOHASH(").put(toBits).put("b)");
            }
            case 11: {
                switch (ColumnType.tagOf(fromType)) {
                    case 14: {
                        return CastGeoHashToGeoHashFunctionFactory.getGeoByteToStrCastFunction(value, fromBits);
                    }
                    case 15: {
                        return CastGeoHashToGeoHashFunctionFactory.getGeoShortToStrCastFunction(value, fromBits);
                    }
                }
            }
        }
        throw SqlException.position(position).put("cannot cast GEOHASH(").put(fromBits).put("b) to ").put(ColumnType.nameOf(toType));
    }

    @Override
    public String getSignature() {
        return "cast(Gg)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function value = args.getQuick(0);
        int srcType = value.getType();
        int targetType = args.getQuick(1).getType();
        return CastGeoHashToGeoHashFunctionFactory.newInstance(position, value, targetType, srcType);
    }

    private static Function getCastGeoHashToGeoHashFunction(Function value, int toType, int fromType, int shift) {
        switch (ColumnType.tagOf(fromType)) {
            case 14: {
                if (ColumnType.tagOf(toType) != 14) break;
                return new CastByteFunc(shift, toType, value);
            }
            case 15: {
                switch (ColumnType.tagOf(toType)) {
                    case 14: {
                        return new CastShortToByteFunc(shift, toType, value);
                    }
                    case 15: {
                        return new CastGeoShortFunction(shift, toType, value);
                    }
                }
                break;
            }
            case 16: {
                switch (ColumnType.tagOf(toType)) {
                    case 14: {
                        return new CastIntToByteFunc(shift, toType, value);
                    }
                    case 15: {
                        return new CastGeoIntToGeoShortFunction(shift, toType, value);
                    }
                    case 16: {
                        return new CastIntFunc(shift, toType, value);
                    }
                }
                break;
            }
            default: {
                switch (ColumnType.tagOf(toType)) {
                    case 14: {
                        return new CastLongToByteFunc(shift, toType, value);
                    }
                    case 15: {
                        return new CastGeoLongToGeoShortFunction(shift, toType, value);
                    }
                    case 16: {
                        return new CastLongToIntFunc(shift, toType, value);
                    }
                    case 17: {
                        return new CastLongFunc(shift, toType, value);
                    }
                }
            }
        }
        return null;
    }

    private static abstract class AbstractCastGeoByteToStrFunction
    extends StrFunction
    implements UnaryFunction {
        protected final Function value;
        protected final int bits;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public AbstractCastGeoByteToStrFunction(Function value, int bits) {
            this.value = value;
            this.bits = bits;
        }

        @Override
        public final Function getArg() {
            return this.value;
        }

        @Override
        public final CharSequence getStr(Record rec) {
            return this.toSink(this.getValue(rec), this.sinkA);
        }

        @Override
        public final CharSequence getStrB(Record rec) {
            return this.toSink(this.getValue(rec), this.sinkB);
        }

        protected abstract long getValue(Record var1);

        protected abstract void print(long var1, CharSink var3);

        private StringSink toSink(long value, StringSink sink) {
            sink.clear();
            if (value == -1L) {
                sink.put("null");
            } else {
                this.print(value, sink);
            }
            return sink;
        }
    }

    private static class CastGeoShortToStrBitsFunc
    extends AbstractCastGeoByteToStrFunction
    implements UnaryFunction {
        public CastGeoShortToStrBitsFunc(Function value, int bits) {
            super(value, bits);
        }

        @Override
        protected long getValue(Record rec) {
            return this.value.getGeoShort(rec);
        }

        @Override
        protected void print(long value, CharSink sink) {
            GeoHashes.appendBinaryStringUnsafe(value, this.bits, sink);
        }
    }

    private static class CastGeoLongToStrBitsFunc
    extends AbstractCastGeoByteToStrFunction
    implements UnaryFunction {
        public CastGeoLongToStrBitsFunc(Function value, int bits) {
            super(value, bits);
        }

        @Override
        protected long getValue(Record rec) {
            return this.value.getGeoLong(rec);
        }

        @Override
        protected void print(long value, CharSink sink) {
            GeoHashes.appendBinaryStringUnsafe(value, this.bits, sink);
        }
    }

    private static class CastGeoIntToStrBitsFunc
    extends AbstractCastGeoByteToStrFunction
    implements UnaryFunction {
        public CastGeoIntToStrBitsFunc(Function value, int bits) {
            super(value, bits);
        }

        @Override
        protected long getValue(Record rec) {
            return this.value.getGeoInt(rec);
        }

        @Override
        protected void print(long value, CharSink sink) {
            GeoHashes.appendBinaryStringUnsafe(value, this.bits, sink);
        }
    }

    private static class CastGeoByteToStrBitsFunc
    extends AbstractCastGeoByteToStrFunction
    implements UnaryFunction {
        public CastGeoByteToStrBitsFunc(Function value, int bits) {
            super(value, bits);
        }

        @Override
        protected long getValue(Record rec) {
            return this.value.getGeoByte(rec);
        }

        @Override
        protected void print(long value, CharSink sink) {
            GeoHashes.appendBinaryStringUnsafe(value, this.bits, sink);
        }
    }

    private static class CastGeoShortToStrCharsFunc
    extends AbstractCastGeoByteToStrFunction
    implements UnaryFunction {
        public CastGeoShortToStrCharsFunc(Function value, int bits) {
            super(value, bits);
        }

        @Override
        protected long getValue(Record rec) {
            return this.value.getGeoShort(rec);
        }

        @Override
        protected void print(long value, CharSink sink) {
            GeoHashes.appendCharsUnsafe(value, this.bits, sink);
        }
    }

    private static class CastGeoLongToStrCharsFunc
    extends AbstractCastGeoByteToStrFunction
    implements UnaryFunction {
        public CastGeoLongToStrCharsFunc(Function value, int bits) {
            super(value, bits);
        }

        @Override
        protected long getValue(Record rec) {
            return this.value.getGeoLong(rec);
        }

        @Override
        protected void print(long value, CharSink sink) {
            GeoHashes.appendCharsUnsafe(value, this.bits, sink);
        }
    }

    private static class CastGeoIntToStrCharsFunc
    extends AbstractCastGeoByteToStrFunction
    implements UnaryFunction {
        public CastGeoIntToStrCharsFunc(Function value, int bits) {
            super(value, bits);
        }

        @Override
        protected long getValue(Record rec) {
            return this.value.getGeoInt(rec);
        }

        @Override
        protected void print(long value, CharSink sink) {
            GeoHashes.appendCharsUnsafe(value, this.bits, sink);
        }
    }

    private static class CastGeoByteToStrCharsFunc
    extends AbstractCastGeoByteToStrFunction
    implements UnaryFunction {
        public CastGeoByteToStrCharsFunc(Function value, int bits) {
            super(value, bits);
        }

        @Override
        protected long getValue(Record rec) {
            return this.value.getGeoByte(rec);
        }

        @Override
        protected void print(long value, CharSink sink) {
            GeoHashes.appendCharsUnsafe(value, this.bits, sink);
        }
    }

    private static class CastByteFunc
    extends GeoByteFunction
    implements UnaryFunction {
        private final Function value;
        private final int shift;

        public CastByteFunc(int shift, int targetType, Function value) {
            super(targetType);
            this.value = value;
            this.shift = shift;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public byte getGeoByte(Record rec) {
            return (byte)(this.value.getGeoByte(rec) >> this.shift);
        }
    }

    private static class CastShortToByteFunc
    extends GeoByteFunction
    implements UnaryFunction {
        private final Function value;
        private final int shift;

        public CastShortToByteFunc(int shift, int targetType, Function value) {
            super(targetType);
            this.value = value;
            this.shift = shift;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public byte getGeoByte(Record rec) {
            return (byte)(this.value.getGeoShort(rec) >> this.shift);
        }
    }

    public static class CastGeoShortFunction
    extends GeoShortFunction
    implements UnaryFunction {
        private final Function value;
        private final int shift;

        public CastGeoShortFunction(int shift, int targetType, Function value) {
            super(targetType);
            this.value = value;
            this.shift = shift;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public short getGeoShort(Record rec) {
            return (short)(this.value.getGeoShort(rec) >> this.shift);
        }
    }

    public static class CastGeoIntToGeoShortFunction
    extends GeoShortFunction
    implements UnaryFunction {
        private final Function value;
        private final int shift;

        public CastGeoIntToGeoShortFunction(int shift, int targetType, Function value) {
            super(targetType);
            this.value = value;
            this.shift = shift;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public short getGeoShort(Record rec) {
            return (short)(this.value.getGeoInt(rec) >> this.shift);
        }
    }

    private static class CastIntToByteFunc
    extends GeoByteFunction
    implements UnaryFunction {
        private final Function value;
        private final int shift;

        public CastIntToByteFunc(int shift, int targetType, Function value) {
            super(targetType);
            this.value = value;
            this.shift = shift;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public byte getGeoByte(Record rec) {
            return (byte)(this.value.getGeoInt(rec) >> this.shift);
        }
    }

    private static class CastIntFunc
    extends GeoIntFunction
    implements UnaryFunction {
        private final Function value;
        private final int shift;

        public CastIntFunc(int shift, int targetType, Function value) {
            super(targetType);
            this.value = value;
            this.shift = shift;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public int getGeoInt(Record rec) {
            return this.value.getGeoInt(rec) >> this.shift;
        }
    }

    private static class CastLongToIntFunc
    extends GeoIntFunction
    implements UnaryFunction {
        private final Function value;
        private final int shift;

        public CastLongToIntFunc(int shift, int targetType, Function value) {
            super(targetType);
            this.value = value;
            this.shift = shift;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public int getGeoInt(Record rec) {
            return (int)(this.value.getGeoLong(rec) >> this.shift);
        }
    }

    public static class CastGeoLongToGeoShortFunction
    extends GeoShortFunction
    implements UnaryFunction {
        private final Function value;
        private final int shift;

        public CastGeoLongToGeoShortFunction(int shift, int targetType, Function value) {
            super(targetType);
            this.value = value;
            this.shift = shift;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public short getGeoShort(Record rec) {
            return (short)(this.value.getGeoLong(rec) >> this.shift);
        }
    }

    private static class CastLongToByteFunc
    extends GeoByteFunction
    implements UnaryFunction {
        private final Function value;
        private final int shift;

        public CastLongToByteFunc(int shift, int targetType, Function value) {
            super(targetType);
            this.value = value;
            this.shift = shift;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public byte getGeoByte(Record rec) {
            return (byte)(this.value.getGeoLong(rec) >> this.shift);
        }
    }

    private static class CastLongFunc
    extends GeoLongFunction
    implements UnaryFunction {
        private final Function value;
        private final int shift;

        public CastLongFunc(int shift, int targetType, Function value) {
            super(targetType);
            this.value = value;
            this.shift = shift;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public long getGeoLong(Record rec) {
            return this.value.getGeoLong(rec) >> this.shift;
        }
    }
}

