/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastDateToTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Mn)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function var = args.getQuick(0);
        return new CastDateToTimestampFunction(var);
    }

    public static class CastDateToTimestampFunction
    extends TimestampFunction
    implements UnaryFunction {
        private final Function arg;

        public CastDateToTimestampFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getTimestamp(Record rec) {
            long value = this.arg.getDate(rec);
            return value == Long.MIN_VALUE ? value : value * 1000L;
        }
    }
}

